% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objectivefun.R
\name{SquaredLoss}
\alias{SquaredLoss}
\title{Squared Loss of Objective}
\usage{
SquaredLoss(x, StdRes, StdTherm_Val, StdTherm_Beta, Tdata)
}
\arguments{
\item{x}{a vector of the indices of each component}

\item{StdRes}{a vector of available resistor values}

\item{StdTherm_Val}{a vector of available nominal thermistor resistances}

\item{StdTherm_Beta}{a vector of of thermistor temperature coefficients}

\item{Tdata}{a vector of temperature-change values}
}
\value{
the squared loss
}
\description{
Measuring the difference between the V-DeltaT Curve you get
   and the target curve under squared loss.
}
\examples{
data(CompValues)
Tdata <- seq(-40, 85, by=5)
R_id <- c(43, 36, 29, 15, 9, 3)
Res <- CompValues$Res
ThVal <- CompValues$ThVal
ThBeta <- CompValues$ThBeta
SquaredLoss(R_id, Res, ThVal, ThBeta, Tdata)
### 0.04066336
}
