% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TabaPartial.R
\name{taba.partial}
\alias{taba.partial}
\title{Robust Partial and Semipartial Correlation}
\usage{
taba.partial(x, y, ..., regress, method = c("taba", "tabarank"),
             alternative = c("less", "greater", "two.sided"),
             semi = c("none", "x", "y"), omega = 0.45)
}
\arguments{
\item{x}{A numeric vector of length greater than 2 must be same length as y and covariates
listed in ...}

\item{y}{A numeric vector of length greater than 2 must be same length as x and covariates
listed in ...}

\item{...}{Numeric vectors used as covariates of length equal to x and y}

\item{regress}{A string variable "\code{linear}" for linear regression, "\code{logistic}" for binary
logistic regression, and "\code{poisson}" for Poisson regression}

\item{method}{A character string of \code{"taba"} or \code{"tabarank"} determining
if one wants to calculate Taba linear or Taba rank (monotonic) correlation,
respectively. If no method is specified, the function will output Taba
linear correlation.}

\item{alternative}{Character string specifying the alternative hypothesis must be one
of \code{"less"} for negative association, \code{"greater"} for
positive association, or \code{"two.sided"} for difference in association.
If the alternative is not specified, the function will default to a two sided test.}

\item{semi}{A character string specifying which variable (x or y) should be adjusted.}

\item{omega}{Numeric allowing the user to alter the tuning constant. If one is not specified,
the function will default to 0.45. Range is between 0 and 1.}
}
\value{
This function returns the robust linear or monotonic association
  between two numeric vectors, adjusting for specified covariates. In addition,
  this function can provide the semipartial correlation, if specified.
}
\description{
Calculates a partial or semipartial correlation using one of the
   specified robust methods Taba linear or Taba rank correlation.
}
\details{
This function calculates the partial or semipartial association of two
   numeric vectors, or columns of a matrix or data frame composed
   of more than two numeric elements, adjusting for covariates of length equal to
   x and y. Covariates are combined colomn-wise and can be numeric vectors, matricies,
   or data frames with numeric cells. Each column in the matrix or data frame will be
   treated as a different covariate, and must have different names from x and y.
   Missing values in x, y, or any of the covariates are deleted row-wise.
   The default for this function is a two sided test using Taba linear partial
   correlation, with the tuning constant \code{omega} equal to 0.45.
   Thr variable you are not controlling must be continuous when using semipartial correlation.
}
\examples{
x = rnorm(100)
y = rnorm(100)
z1 = rnorm(100)
z2 = rnorm(100)
z3 = rnorm(100)
taba.partial(x, y, z1, z2, z3, method = "tabarank")
taba.partial(x, y, z2, alternative = "less", semi = "x")
}
\references{
The paper is under review for possible publication.
}
\seealso{
\code{\link{taba}} for calculating Taba linear or Taba rank (monotonic) correlations
  \cr\code{\link{taba.test}} for testing Taba linear or Taba rank (monotonic) correlations
  \cr\code{\link{taba.gpartial}} for generalized partial correlations
  \cr\code{\link{taba.matrix}} for calculating correlation, p-value, and distance matricies
}
