% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_seasonal.R
\name{ts_quantile}
\alias{ts_quantile}
\title{Quantile Plot for Time Series}
\usage{
ts_quantile(ts.obj, upper = 0.75, lower = 0.25, period = NULL,
  n = 1, title = NULL, Xtitle = NULL, Ytitle = NULL)
}
\arguments{
\item{ts.obj}{A univariate time series object of a class "zoo", "xts", or data frame family ("data.frame", "data.table", "tbl")}

\item{upper}{A numeric value between 0 and 1 (excluding 0, and greater than the "lower" argument) set the upper bound of the quantile plot 
(using the "probs" argument of the \code{\link[stats]{quantile}} function). By default set to 0.75}

\item{lower}{A numeric value between 0 and 1 (excluding 1, and lower than the "upper" argument) set the upper bound of the quantile plot 
(using the "probs" argument of the \code{\link[stats]{quantile}} function). By default set to 0.25}

\item{period}{A character, set the period level of the data for the quantile calculation and plot representation. 
Must be one level above the input frequency (e.g., an hourly data can represent by daily, weekdays, monthly, quarterly and yearly). 
Possible options c("daily", "weekdays", "monthly", "quarterly", "yearly")}

\item{n}{An integer, set the number of plots rows to display (by setting the nrows argument in the \code{\link[plotly]{subplot}} function), must be an integer between 1 and the frequency of the period argument.}

\item{title}{A character, set the plot title, default set to NULL}

\item{Xtitle}{A character, set the X axis title, default set to NULL}

\item{Ytitle}{A character, set the Y axis title, default set to NULL}
}
\description{
A quantile plot of time series data, allows the user to display a quantile plot of a series by a subset period
}
\examples{

\dontrun{

# Loading the UKgrid package to pull a multie seasonality data
require(UKgrid)

UKgrid_half_hour <- extract_grid(type = "xts", aggregate = NULL)

# Plotting the quantile of the UKgrid dataset
# No period subset
ts_quantile(UKgrid_half_hour, 
period = NULL, 
title = "The UK National Grid Net Demand for Electricity - Quantile Plot")
 
# Plotting the quantile of the UKgrid dataset
# Using a weekday subset
ts_quantile(UKgrid_half_hour, 
period = "weekdays",
title = "The UK National Grid Net Demand for Electricity - by Weekdays")

# Spacing the plots by setting the 
# number of rows of the plot to 2
ts_quantile(UKgrid_half_hour, 
period = "weekdays",
title = "The UK National Grid Net Demand for Electricity - by Weekdays",
n = 2)
}
}
