% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AnnaulClimCal.R
\name{AnnualClim.Cal}
\alias{AnnualClim.Cal}
\title{Antecedental accumulation calculator for the annual max VI time series}
\usage{
AnnualClim.Cal(anu.VI, VI.index, ACP.table, ACT.table = NULL,
  Breakpoint = FALSE, allow.negative = FALSE, allowneg.retest = FALSE)
}
\arguments{
\item{anu.VI}{The annual (Growing season) max VI. Must be a object of class \code{'ts'} without NA's.
if anu.VI=FALSE, it will be calculated from the CTSR.VI using \code{\link{AnMaxVI}}.}

\item{VI.index}{the index of the CTSR.VI ts that the anu.VI values occur at. Must be the same length
as anu.VI. NOTE. R indexs from 1 rather than 0.
if VI.index=FALSE, it will be calculated from the CTSR.VI using \code{\link{AnMaxVI}}.}

\item{ACP.table}{A table of every combination of offset period and accumulation period.for precipitation
ACP.table can be calculated using the \code{\link{climate.accumulator}}.}

\item{ACT.table}{A table of every combination of offset period and accumulation period.for temperature
ACP.table can be calculated using the \code{\link{climate.accumulator}}.}

\item{Breakpoint}{Used when calcualting rf.bf and rf.af for ts with breakpoints in the VPR.  See \code{\link{CHOW}}}

\item{allow.negative}{If true, will not preference positive slope in either CTSR or VI calculations. default=FALSE is set
because negative associations between rainfall and vegetation in water limited ecosystems is unexpected
If temperature data is included then this paramter is forced to TRUE.}

\item{allowneg.retest}{default=FALSE
If temperature data is provided but found to not be significant then a retest is performed.
This paramter is to allow negative on re-test.}
}
\value{
\bold{summary}
       a Matrix containing "slope", "intercept", "p.value", "R^2.Value", "Break.Height", "Slope.Change"
       of the \code{\link[stats]{lm}} of VI ~ rainfall. If Breakpoint, summary covers both rf.b4 and rf.af.

\bold{acu.RF}
       (aka. annual.precip)The optimal accumulated rainfall for anu.VI. Mut be a object of class 'ts'
       and of equal length to anu.VI. It is caculated from the ACP.table by finding the acp and osp
       that has the largest R^2 value. \code{\link[stats]{lm}}(anu.VI ~ rainfall)

\bold{acu.TM}
       (aka, annual.temp) The optimal accumulated rainfall for anu.T<. Mut be a object of class 'ts'
       and of equal length to anu.VI. It is caculated from the ACT.table by finding the tacp and tosp
        that has the largest R^2 value. \code{\link[stats]{lm}}(anu.VI ~ rainfall+temperature)

\bold{rf.b4}
       The optimal acumulated rainfall before the Breakpoint

\bold{rf.af}
       The Optimally accumulated rainfall after the Breakpoint

\bold{tm.b4}
       The optimal acumulated temperature before the Breakpoint

\bold{tm.af}
       The Optimally accumulated temperature after the Breakpoint

\bold{osp}
       The offest period for the annual max time series rainfall

\bold{acp}
       The accumulation period for the annual max time series rainfall

\bold{tosp}
       The offest period for the annual max time series temperature

\bold{tacp}
       The accumulation period for the annual max time series temperature
}
\description{
Takes the Annual Max VI Time Series, the VI.index and tables of every possible accumulation
period and offset period for preciptation and Temperature (optional).  A OLS is calculated
\code{\link[stats]{lm}} for every combination of VI ~ rainfall. If temperature is provided
The formula is (VI ~ rainfall + temperature).  By defualt, this function preferences those results where
slope>0 (increase in rainfall causes an increase in vegetation), returning the rainfall accumulation
that has the highest R-squared and a positive slope. If no combinations produce a positive slope then the
one with the highest Rsquared is returned.
TO DO: non peramtric and other variables
}
\examples{
ARC <- AnnualClim.Cal(stdRESTREND$max.NDVI, stdRESTREND$index, stdRESTRENDrfTab)
print(ARC)
\dontrun{

#Test the complete time series for breakpoints
VPRBFdem <- VPR.BFAST(segVPRCTSR$cts.NDVI, segVPRCTSR$cts.precip)
bp<-as.numeric(VPRBFdem$bkps)

#test the significance of the breakpoints
reschow <- CHOW(segVPR$max.NDVI, segVPR$acum.RF, segVPR$index, bp)
brkp <- as.integer(reschow$bp.summary["yr.index"])
ARCseg <-AnnualClim.Cal(segVPR$max.NDVI, segVPR$index, segVPRrfTab, Breakpoint = brkp)
print(ARCseg)
}
}
\author{
Arden Burrell, arden.burrell@unsw.edu.au
}

