% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gene_cluster_trend.R
\name{gene_cluster_trend}
\alias{gene_cluster_trend}
\title{Gene cluster trend plot for visualizing gene expression trend profile in multiple samples.}
\usage{
gene_cluster_trend(
  data,
  thres = 0.25,
  min_std = 0.2,
  palette = "PiYG",
  cluster_num = 4
)
}
\arguments{
\item{data}{Dataframe: Shared DEGs of all paired comparisons in all groups expression dataframe of RNA-Seq. (1st-col: Genes, 2nd-col~n-1-col: Groups, n-col: Pathways).}

\item{thres}{Number: set the threshold for excluding genes. Default: 0.25.}

\item{min_std}{Number: set the threshold for minimum standard deviation. Default: 0.2.}

\item{palette}{Character: set the color palette to be used for plotting. Default: "PiYG", options: 'Spectral', 'BrBG', 'PiYG', 'PRGn', 'PuOr', 'RdBu', 'RdGy', 'RdYlBu', 'RdYlGn'.}

\item{cluster_num}{Number: set the number of clusters. Default: 4.}
}
\value{
Plot: Gene cluster trend plot for visualizing gene expression trend profile in multiple samples.
}
\description{
Gene cluster trend plot for visualizing gene expression trend profile in multiple samples.
}
\examples{
# 1. Library TOmicsVis package
library(TOmicsVis)

# 2. Use example dataset gene_cluster_data
data(gene_expression3)
head(gene_expression3)

# 3. Default parameters
gene_cluster_trend(gene_expression3[,-7])

# 4. Set palette = "RdBu"
gene_cluster_trend(gene_expression3[,-7], palette = "RdBu")

# 5. Set cluster_num = 6
gene_cluster_trend(gene_expression3[,-7], cluster_num = 6, palette = "Spectral")

}
\author{
wei dong
}
