% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.TLMoments.R
\name{plot.TLMoments}
\alias{plot.TLMoments}
\title{L-Moment-ratio diagram}
\usage{
\method{plot}{TLMoments}(x, distr, ...)
}
\arguments{
\item{x}{object of TLMoments.}

\item{distr}{character indicating the plotted theoretical distributions, see details.}

\item{...}{additional arguments, not used at the moment.}
}
\value{
A ggplot object.
}
\description{
Generates a ggplot2 object containing a scatterplot of TL skewness and TL kurtosis
as well as the theoretical curves and points of several distributions (today: GEV, GPD,
LN3, GUM, EXP, NORM).
}
\details{
\code{distr}: this can either be a vector containing the abbreviations of the
theoretical distributions (gev, gpd, ln3, gum, exp, or norm) or one of the
shortcuts \"all\" (default), \"only-lines\", or \"only-points\" that indicate
all distributions, all distributions displayed as lines (i.e. gev, gpd, ln3),
or all distributions displayed as points (ie. gum, exp, norm), respectively.

Values of theoretical distributions are pre-calculated for several trimmings.
If other trimmings are selected this results in a (small) delay for calculation.
}
\examples{
\dontrun{
xmat <- matrix(rgev(1000, shape = .3), nc = 10)
xvec <- xmat[, 3]
xlist <- lapply(1L:ncol(xmat), function(i) xmat[, i])
xdat <- data.frame(
 station = rep(letters[1:10], each = 100),
 season = rep(c("S", "W"), 50),
 hq = as.vector(xmat)
)

library(ggplot2)
plot(TLMoments(xvec))
plot(TLMoments(xlist), distr = c("gev", "gum"))
plot(TLMoments(xmat), distr = "only-points")
plot(TLMoments(xmat), distr = "only-lines") + scale_colour_viridis_d()
plot(TLMoments(xmat, 0, 1))
plot(TLMoments(xmat, 0, 1)) + coord_cartesian(xlim = c(-.05, .4), ylim = c(.05, .2))
plot(TLMoments(xdat, hq ~ station, 1, 0))
}
}
