% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WindHazaRds.R
\name{TCHazaRdsWindFields}
\alias{TCHazaRdsWindFields}
\title{Compute the Wind and Pressure Spatial Hazards Field Associated with TC track.}
\usage{
TCHazaRdsWindFields(
  outdate = NULL,
  GEO_land,
  TC,
  paramsTable,
  outfile = NULL,
  overwrite = FALSE
)
}
\arguments{
\item{outdate}{array of POSITx date times to linearly interpolate TC track}

\item{GEO_land}{SpatVector or dataframe hazard geometry generated with land_geometry}

\item{TC}{SpatVector of Tropical cyclone track parameters for a single time step}

\item{paramsTable}{Global parameters to compute TC Hazards}

\item{outfile}{character. Output netcdf filename}

\item{overwrite}{TRUE/FALSE, option to overwrite outfile}
}
\value{
SpatRasterDataset with the following attributes.\tabular{lll}{
   abbreviated attribute \tab description \tab units \cr
   P \tab Atmospheric pressure \tab hPa \cr
   Uw \tab Meridional  wind speed \tab m/s \cr
   Vw \tab Zonal wind speed \tab m/s \cr
   Sw \tab Wind speed \tab m/s \cr
   Dw \tab The direction from which wind originates \tab deg clockwise from true north \cr
}
}
\description{
Compute the Wind and Pressure Spatial Hazards Field Associated with TC track.
}
\examples{
require(terra)
dem <- rast(system.file("extdata/DEMs/YASI_dem.tif", package="TCHazaRds"))
land <- dem; land[land > 0] = 0
inland_proximity = distance(land,target = 0)
GEO_land = land_geometry(dem,inland_proximity)

TCi = vect(cbind(c(154,154),c(-26.1,-26)),"lines",crs="epsg:4283") #track line segment
TCi$PRES = 950
TCi$RMW = 40
TCi$ISO_TIME = "2022-10-04 20:00:00"
TCi$LON = geom(TCi)[1,3]
TCi$LAT = geom(TCi)[1,4]
TCi$STORM_SPD = perim(TCi)/(3*3600) #m/s
TCi$thetaFm = 90-returnBearing(TCi)
#OR
TC <- vect(system.file("extdata/YASI/YASI.shp", package="TCHazaRds"))
TC$PRES <- TC$BOM_PRES
plot(dem);lines(TC,lwd = 4,col=2)

paramsTable = read.csv(system.file("extdata/tuningParams/defult_params.csv",package = "TCHazaRds"))
#calculate the wind hazard

outdate = seq(strptime(TC$ISO_TIME[44],"\%Y-\%m-\%d \%H:\%M:\%S",tz="UTC"),
              strptime(TC$ISO_TIME[46],"\%Y-\%m-\%d \%H:\%M:\%S",tz="UTC"),
              3600*3)
HAZi = TCHazaRdsWindFields(outdate=outdate,GEO_land=GEO_land,TC=TC,paramsTable=paramsTable)
plot(min(HAZi$Pr))

}
