% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/features_02_claim_size.R
\name{claim_size}
\alias{claim_size}
\title{Claim Size}
\usage{
claim_size(frequency_vector, S_cdf, range = c(0, 1e+24), ...)
}
\arguments{
\item{frequency_vector}{a vector of claim frequencies for all the periods.}

\item{S_cdf}{(optional) cumulative distribution function to be sampled from.}

\item{range}{the possible set of values of claim sizes, with default
(0, 1e24).}

\item{...}{other arguments/parameters to be passed onto \code{S_cdf}.}
}
\value{
A list of claim sizes such that the \eqn{i}th component of the
list gives the sizes for all claims that occurred in period \eqn{i}.
}
\description{
Simulates and returns the size of each of the claims occurring in each of
the periods, given its cumulative distribution function.
\cr \cr Note that \code{claim_size()} aims to model the claim sizes
\strong{without inflation}.
}
\details{
By default \code{claim_size()} assumes a left truncated power
normal distribution: \eqn{S^0.2 ~ Normal (9.5, sd = 3)}, left truncated
at 30. The truncation is done via resampling for rejected values. \cr \cr
Users can opt to use predefined distributions if desired. See Examples.
}
\examples{
n_vector <- c(90, 79, 102, 78, 86, 88, 116, 84, 93, 104)
claim_size(n_vector)[[1]] # gives the sizes for all
                          # all claims incurred in period 1

# with some custom pre-defined distribution function
claim_size(n_vector, stats::pweibull, shape = 4, scale = 100000)[[1]]
}
