% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/features_06_claim_payment_size.R
\name{claim_payment_size}
\alias{claim_payment_size}
\title{Size of Partial Payments (Without Inflation)}
\usage{
claim_payment_size(
  frequency_vector,
  claim_size_list,
  no_payments_list,
  simulate_amt_pmt_function
)
}
\arguments{
\item{frequency_vector}{a vector of claim frequencies for all the periods.}

\item{claim_size_list}{list of claim sizes.}

\item{no_payments_list}{list of number of partial payments.}

\item{simulate_amt_pmt_function}{a function that generates and returns the
payment pattern of a particular claim (as a vector of size = \code{no_pmt}),
conditional on \code{no_pmt} and \code{claim_size} (see Details for the
default simulation function).}
}
\description{
Simulates and returns the constant dollar amount of each partial payment
(i.e.\strong{without inflation}) for each of the claims occurring in each of
the periods.
}
\details{
Returns a compound list structure such that the \eqn{j}th component
of the \eqn{i}th sub-list gives the payment pattern (as a vector) for the
\eqn{j}th claim of occurrence period \eqn{i}. \cr \cr
The default \code{simulate_amt_pmt_function} is set up in three steps. First
we sample the \emph{complement} of the porportion of total claim size
represented by the last two payments, from a Beta distribution with mean
\deqn{1 - min(0.95, 0.75 + 0.04log[claim_size/(0.10 * ref_claim)])} where
\code{ref_claim} is a package-wise global variable that we ask the user to define
at the top of their code using \code{\link{set_parameters}}. CoV is assumed
constant at 20\%.
\cr \cr
Next we simulate the porportion of last_two_pmts paid in the second last
payment (\emph{settlement of the claim}) from a Beta distribution with
mean = 0.90 and CoV = 3\%.
\cr \cr
Lastly we sample the remaining payment proportions from a Beta distribution
with mean \deqn{(1 - last_two_payments)/(no_pmt - 2)} and CoV = 10\%, which
is followed by a normalisation such that the proportions add up to 1.
\cr \cr
In the cases where there are only 2 or 3 partial payments, proceed as if
there were 4 or 5 payments respectively with last_two_payments = 0. The
trivial case is when the claim is settled with a single payment, which must
be of the same amount as the total claim size.
}
\section{Explanation}{
 Why did we set up a payment pattern as above? \cr \cr
The payment pattern is set up to reflect the typical pattern of a claim from
an Auto liability line of business, which usually consists of:
\enumerate{
\item (possibly) some small payments such as police reports, medical
consultations and reports;
\item some more substantial payments such as hospitalisation, specialist
medical procedures, equipment (e.g. prosthetics);
\item a final settlement with the claimant (usually the second last payment);
\item a smaller final payment, usually covering legal costs.
}
Claims in a number of other lines of business exhibit a similar structure,
albeit with possible differences in the types of payment made.
}

\examples{
# set up
n_vector <- claim_frequency(I = 10)
claim_sizes <- claim_size(n_vector)
no_payments <- claim_payment_no(n_vector, claim_sizes)

# with default simulate_amt_pmt_function
payments <- claim_payment_size(n_vector, claim_sizes, no_payments)
# partial payment sizes for claim 1 of occurrence period 1
payments[[1]][[1]]

# with some custom simulate_amt_pmt_function
# simplest case: (stochastically) equal amounts
my_func <- function(no_pmt, claim_size) {
  prop <- runif(no_pmt)
  prop <- prop/sum(prop)
  claim_size * prop
}
mypayments <- claim_payment_size(n_vector, claim_sizes, no_payments, my_func)
# partial payment sizes for claim 1 of occurrence period 1
mypayments[[1]][[1]]
}
