% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDScoreHeatmap.R
\name{plotDScoreHeatmap}
\alias{plotDScoreHeatmap}
\title{Plot a heat map of the normalized drug-disease reverse association scores for cancer samples}
\usage{
plotDScoreHeatmap(
  data,
  subtype.label = "all",
  SDS = "all",
  E_Pvalue.th = 1,
  E_FDR.th = 0.05,
  S_Pvalue.th = 1,
  S_FDR.th = 0.001,
  show.rownames = TRUE,
  show.colnames = FALSE,
  color = colorRampPalette(c("#0A8D0A", "#F8F0EB", "red"))(190),
  subtype_colors = NA,
  drug_colors = NA,
  border_color = "grey60",
  cellwidth = NA,
  cellheight = NA,
  fontsize = 10,
  fontsize.row = 10,
  fontsize.col = 10,
  scale = "row"
)
}
\arguments{
\item{data}{A list of result data generated by function `PrioSubtypeDrug()`.}

\item{subtype.label}{Character string indicates which sample of the cancer subtype was used to plot the heat map.
If subtype.label = "all" (default), all cancer samples will be shown in the heat map.}

\item{SDS}{A string indicates that the range of SDS is used for the heat map. if SDS="all" (default), the SDS will not be filtered.
SDS="negative", only drugs with SDS<0 are used. SDS="positive", only drugs with SDS>0 are used.}

\item{E_Pvalue.th}{A numeric.A threshold is used to filter the drug effected P value (default: 1).}

\item{E_FDR.th}{A numeric.A threshold is used to filter the drug effected FDR (default: 0.05).}

\item{S_Pvalue.th}{A numeric.A threshold is used to filter the Subtype specific P value (default: 1).}

\item{S_FDR.th}{A numeric.A threshold is used to filter the Subtype specific P value (default: 0.001).}

\item{show.rownames}{Boolean specifying if row names are be shown (default: TRUE).}

\item{show.colnames}{Boolean specifying if column names are be shown (default: FALSE).}

\item{color}{Vector of colors used in heatmap.}

\item{subtype_colors}{Vector of colors is used to annotate the sample subtype.Its length should correspond to the number of sample subtypes.}

\item{drug_colors}{Vector of colors is used to label subtype-specific drugs.}

\item{border_color}{Color of cell borders on heatmap, use NA if no border should be drawn.}

\item{cellwidth}{Individual cell width in points. If left as NA, then the values depend on the size of plotting window.}

\item{cellheight}{Individual cell height in points. If left as NA, then the values depend on the size of plotting window.}

\item{fontsize}{Base fontsize for the plot (default: 10).}

\item{fontsize.row}{Fontsize for rownames (default: 10).}

\item{fontsize.col}{Fontsize for colnames (default: 10).}

\item{scale}{Character indicating if the values should be centered and scaled in either the row direction or the column direction, or none. Corresponding values are "row" (default), "column" and "none".}
}
\value{
A heat map.
}
\description{
According to the parameter setting, the function `plotDScoreHeatmap()` displays the heat map of the normalized
drug-disease reverse association score for the significant drugs.
}
\details{
plotDScoreHeatmap
}
\examples{
require(pheatmap)
## Get the result data of PrioSubtypeDrug().
## The data is based on the simulated breast cancer subtype data.
Subtype_drugs<-get("Subtype_drugs")
## Heat map of all subtype-specific drugs.
\donttest{plotDScoreHeatmap(data=Subtype_drugs,E_Pvalue.th=0.05,
                            S_Pvalue.th=0.05)}
## Plot only Basal subtype-specific drugs.
plotDScoreHeatmap(Subtype_drugs,subtype.label="Basal",SDS="all",E_Pvalue.th=0.05,
                  E_FDR.t=1,S_Pvalue.th=0.05,S_FDR.th=1)
}
\author{
Xudong Han,
Junwei Han,
Chonghui Liu
}
