% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_importance.R
\name{plot_importance}
\alias{plot_importance}
\title{Importance Plot: Visualize relative importance of variables}
\usage{
plot_importance(object, top_n = NULL, ...)
}
\arguments{
\item{object}{PRISM object}

\item{top_n}{Show top_n variables only, default=NULL (show all)}

\item{...}{Additional arguments (currently ignored).}
}
\value{
Plot (ggplot2) object
}
\description{
Importance is currently based on the PRISM filter model. For elastic net (filter_glmnet).
variables with non-zero coefficients are shown. For random forest variable importance 
(filter_ranger), variables are sorted by their p-values, and "top_n" will show only the
"top_n" most importance variables (based on p-values).
}
\examples{
library(StratifiedMedicine)
## Continuous ##
dat_ctns = generate_subgrp_data(family="gaussian")
Y = dat_ctns$Y
X = dat_ctns$X
A = dat_ctns$A

mod1 = filter_train(Y=Y, A=A, X=X)
plot_importance(mod1)
}
