% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_glmnet.R
\name{filter_glmnet}
\alias{filter_glmnet}
\title{Filter: Elastic Net (glmnet)}
\usage{
filter_glmnet(Y, A, X, lambda = "lambda.min", family = "gaussian",
  interaction = FALSE, ...)
}
\arguments{
\item{Y}{The outcome variable. Must be numeric or survival (ex; Surv(time,cens) )}

\item{A}{Treatment variable. (a=1,...A)}

\item{X}{Covariate space.}

\item{lambda}{Lambda for elastic net model (default="lambda.min"). Other options include
"lambda.1se" and fixed values}

\item{family}{Outcome type ("gaussian", "binomial", "survival"), default is "gaussian"}

\item{interaction}{Regress Y~X+A+A*X (interaction between covariates and treatment)?
Default is FALSE. If TRUE, variables with zero coefficients (both X and X*A terms)
are filtered.}

\item{...}{Any additional parameters, not currently passed through.}
}
\value{
Filter model and variables that remain after filtering.
 \itemize{
  \item mod - Filtering model
  \item filter.vars - Variables that remain after filtering (could be all)
}
}
\description{
Filter variables through elastic net (Zou and Hastie 2005). Default is to regress
Y~X (search for prognostic variables). Variables with estimated coefficients of zero
(depends on lambda choice; default is lambda.min) are filtered. Usable for continuous,
binary, and survival outcomes.
}
\examples{

library(StratifiedMedicine)

## Continuous ##
dat_ctns = generate_subgrp_data(family="gaussian")
Y = dat_ctns$Y
X = dat_ctns$X
A = dat_ctns$A

# Default: Regress Y~X (search for prognostic factors) #
mod1 = filter_glmnet(Y, A, X)
mod2 = filter_glmnet(Y, A, X, lambda = "lambda.min") # same as default
mod3 = filter_glmnet(Y, A, X, lambda = "lambda.1se")
mod1$filter.vars
mod2$filter.vars
mod3$filter.vars

# Interaction=TRUE; Regress Y~X+A+X*A (search for prognostic and/or predictive) #
mod4 = filter_glmnet(Y, A, X, interaction=TRUE)
mod4$filter.vars
}
\references{
Friedman, J., Hastie, T. and Tibshirani, R. (2008) Regularization Paths for
 Generalized Linear Models via Coordinate Descent,
 \url{https://web.stanford.edu/~hastie/Papers/glmnet.pdf} Journal of Statistical 
 Software, Vol. 33(1), 1-22 Feb 2010 Vol. 33(1), 1-22 Feb 2010.
}
