% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/submod_lmtree.R
\name{predict.submod_lmtree}
\alias{predict.submod_lmtree}
\title{Predict submod: lmtree}
\usage{
\method{predict}{submod_lmtree}(object, newdata = NULL, ...)
}
\arguments{
\item{object}{Trained lmtree model.}

\item{newdata}{Data-set to make predictions at (Default=NULL, predictions correspond
to training data).}

\item{...}{Any additional parameters, not currently passed through.}
}
\value{
Identified subgroups with subgroup-specific predictions of E(Y|A=1)-E(Y|A=0).
\itemize{
  \item Subgrps - Identified subgroups
  \item pred - Predictions, E(Y|A=1)-E(Y|A=0) by subgroup.
}
}
\description{
Predict subgroups and obtain subgroup-specific estimates of E(Y|A=1)-E(Y|A=0).
}
\examples{
library(StratifiedMedicine)

## Continuous ##
dat_ctns = generate_subgrp_data(family="gaussian")
Y = dat_ctns$Y
X = dat_ctns$X
A = dat_ctns$A

res_lmtree1 = submod_lmtree(Y, A, X, Xtest=X)
# Predict subgroups / estimates #
out = predict(res_lmtree1)


}
