% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/param_rmst.R
\name{param_rmst}
\alias{param_rmst}
\title{Parameter Estimation: RMST}
\usage{
param_rmst(Y, A, X, mu_hat, alpha_ovrl, alpha_s, Subgrps, ...)
}
\arguments{
\item{Y}{The outcome variable. Must be numeric or survival (ex; Surv(time,cens) )}

\item{A}{Treatment variable. (a=1,...A)}

\item{X}{Covariate matrix. Must be numeric.}

\item{mu_hat}{Patient-level estimates (See PLE_models)}

\item{alpha_ovrl}{Two-sided alpha level for overall population}

\item{alpha_s}{Two-sided alpha level at subgroup}

\item{Subgrps}{Identified subgroups (can be the overall population)}

\item{...}{Any additional parameters, not currently passed through.}
}
\value{
Data-set with parameter estimates (RMST) and corresponding
variability metrics, for overall and subgroups.
 \itemize{
  \item param.dat - Parameter estimates and variability metrics
  }
}
\description{
For each identified subgroups and in the overall population, estimate the restricted
mean survival time (RMST). IN PROGRESS
}
\examples{

\donttest{
library(StratifiedMedicine)
## Survival Data ##

# MOB-Weibull Subgroup Model ##
res_weibull = submod_weibull(Y, A, X, Xtest=X, family="survival")
plot(res_weibull$mod)

## Parameter-Estimation ##
params = param_rmst(Y, A, X, Subgrps = res_weibull$Subgrps.train, alpha_ovrl=0.05,
                   alpha_s=0.05)
params
}


}
