% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helperFunctions.R
\name{weightsMlLoglik}
\alias{weightsMlLoglik}
\title{Computes weights for parts of the multilevel network based on random errors using the SS approach with complete blocks only (compatible with k-means)}
\usage{
weightsMlLoglik(
  mlNet,
  cluParts,
  k,
  mWeights = 1000,
  sumFun = sd,
  nCores = 0,
  weightClusterSize = 0,
  paramGenPar = list(genPajekPar = FALSE),
  ...
)
}
\arguments{
\item{mlNet}{A multilevel/linked network - The code assumes only one relation --> a matrix.}

\item{cluParts}{A partition spliting the units into different sets}

\item{k}{A vecotor of number of clusters for each set of units in the network.}

\item{mWeights}{The number of repetitions for computing random errors. Defaults to 1000}

\item{sumFun}{The function to compute the summary of errors, which is then used to compute the weights by computing 1/summary. Defaults to \code{sd}.}

\item{nCores}{The number of to use for parallel computing. 0 means all available - 1, 1 means only once core - no parallel computing.}

\item{weightClusterSize}{The weight given to cluster sizes. Defalults to 0, as only this is weighted my the tie-based weights.}

\item{paramGenPar}{The parameter \code{addParam} from  \code{\link[blockmodeling]{genRandomPar}} (see documentation there). Default here is paramGenPar=list(genPajekPar = FALSE), which is different from the default in \code{\link[blockmodeling]{genRandomPar}}. The same value is used for generating partitions for all partitions.}

\item{...}{Paramters passed to \code{\link{llStochBlock}}}
}
\value{
Weights and "intermediate results":
 \item{errArr}{A 3d array of errors (\code{mWeights} for each part of the network)}
 \item{errMatSum}{\code{errArr} summed over all repetitions.}
 \item{weightsMat}{A matrix of weights, one for each part. An inverse of \code{errMatSum} with NaNs replaced by zeros.}
}
\description{
Computes weights for parts of the multilevel network based on random errors using the SS approach with complete blocks only (compatible with k-means)
}
\references{
Škulj, D., & Žiberna, A. (2022). Stochastic blockmodeling of linked networks. Social Networks, 70, 240-252.
}
\seealso{
\code{\link{llStochBlock}}; \code{\link{ICLStochBlock}}
}
\author{
\enc{Aleš, Žiberna}{Ales Ziberna}
}
