% Generated by roxygen2 (4.0.1): do not edit by hand
\name{wdmat}
\alias{wdmat}
\title{Compute the weighted distances between two data sets of rankings}
\usage{
wdmat(dset1, dset2 = dset1, dset1.agg = FALSE, dset2.agg = FALSE,
  dtype = "Kendall", weight = NULL, modal = NULL)
}
\arguments{
\item{dset1}{one data set with each row being a ranking}

\item{dset2}{the other data set (default as dset1)}

\item{dset1.agg}{whether the data set is in the aggregated form
(default as FALSE)}

\item{dset2.agg}{whether the data set is in the aggregated form
(default as FALSE)}

\item{dtype}{type of the weighted distance measure
(default as weighted Kendall's)}

\item{weight}{weight vector (default as all components being 1)}

\item{modal}{the modal ranking
(default as c(1:k), k being the number of ranked items)}
}
\value{
a list whose first object is a vector about the aggregation
        status of the two data sets c(dset1.agg, dset2.agg), and
        second object is a matrix of distances.
}
\description{
This function computes the weighted distances between two data sets
of complete rankings. The results are put in the matrix form. The
data set could be aggregated or not.
}
\examples{
data(Croon)
wdmat(Croon, dset1.agg=TRUE, dset2.agg=TRUE)
}
\author{
Yumin Zhang <zymneo@gmail.com>
}

