% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/actvspred.R
\name{actvspred}
\alias{actvspred}
\title{Comparison of actual and predicted linear response}
\usage{
actvspred(y, yhat, n)
}
\arguments{
\item{y}{actual linear response}

\item{yhat}{predicted linear response}

\item{n}{quantiles to be created for comparison}
}
\value{
a data.frame with average actual and predicted response in each quantile
}
\description{
Takes in actual, predicted linear response and quantile value, and returns
 average actual and predicted response in each quantile
}
\details{
\code{actvspred} function divides the data into \code{n} (given as input by the user)
 quantiles and computes mean of \code{y} and \code{yhat} for each quantile. All
 \code{NA}'s in \code{n}, \code{y} and \code{yhat} are removed for calculation.

 The function also plots a line chart of average actual response and average predicted
 response over \code{n} quantiles. This plot can be used to visualize how close both
 the lines are.
}
\examples{
# A 'data.frame' with y and yhat
df <- data.frame(y = c(1, 2, 3, 6, 8, 10, 15),
                 yhat = c(1.2, 2.5, 3.3, 6.9, 9.3, 6.5, 12.3))

# Get actual vs predicted table
ACTVSPRED <- actvspred(y = df[, 'y'], yhat = df[, 'yhat'], n = 5)
}
\author{
Akash Jain
}
\seealso{
\code{\link{mape}}, \code{\link{splitdata}}
}

