<!-- badges: start -->

[![CRAN](https://www.r-pkg.org/badges/version/SqueakR?color=green)](https://cran.r-project.org/package=SqueakR) [![pkgdown](https://github.com/osimon81/SqueakR/actions/workflows/pkgdown.yaml/badge.svg)](https://github.com/osimon81/SqueakR/actions/workflows/pkgdown.yaml) [![License: MIT](https://img.shields.io/badge/license-MIT-blue.svg)](https://cran.r-project.org/web/licenses/MIT)

<!-- badges: end -->

# SqueakR: An Experiment Interface for DeepSqueak Bioacoustics Research

Welcome to the `SqueakR` package!

## Installation

### From CRAN

To install the CRAN release of the package, run the following code:

    install.packages(SqueakR)
    library(SqueakR)

### From GitHub

To install the development version of `SqueakR`, run the following code (ensure devtools is loaded first):

    install_github("osimon81/SqueakR")
    library(SqueakR)

`SqueakR` represents a suite of programs designed to assist researchers with processing and exploring data from experiments which use DeepSqueak for bioacoustics projects. DeepSqueak is a machine-vision program capable of aggregating detected vocalizations based on the features a call might have, allowing subsequent analysis of call syntax, significant changes in call features across groups, etc.

For reference, the entire `SqueakR` suite can be found [under this GitHub list](https://github.com/stars/osimon81/lists/squeakr).

## Resources

The tools and resources available under `SqueakR` include:

-   The `SqueakR` [pkgdown website](https://osimon81.github.io/SqueakR/ "SqueakR Pkgdown Website on GitHub") available through GitHub. Detailed information about its functions can be found under the *Reference* tab on the SqueakR website. The *Get started* tab is the recommended site for learning how to use the package.

-   The [main SqueakR Package repository](https://github.com/osimon81/SqueakR/ "The GitHub repository for SqueakR"), and the corresponding [Wiki](https://github.com/osimon81/SqueakR/wiki/ "SqueakR Wiki") and [Discussions](https://github.com/osimon81/SqueakR/discussions/ "Discussions page for SqueakR repo") sections.

-   The [`SqueakR`](https://cran.r-project.org/package=SqueakR/ "SqueakR Website on CRAN") package itself, and documentation describing its functions, on CRAN.

-   The [SqueakR On Swirl](https://github.com/osimon81/SqueakR-On-Swirl/) course GitHub repository. Installing this course will teach you how to use SqueakR within RStudio itself!

## Contact

If you have any questions that cannot be answered through any of these ways, feel free to contact me at [simon.ogundare\@columbia.edu](mailto:simon.ogundare@columbia.edu), and I'll get back to you as soon as possible.
