# ifndef CPPAD_ARITHMETIC_INCLUDED
# define CPPAD_ARITHMETIC_INCLUDED

/* --------------------------------------------------------------------------
CppAD: C++ Algorithmic Differentiation: Copyright (C) 2003-07 Bradley M. Bell

CppAD is distributed under multiple licenses. This distribution is under
the terms of the 
                    GNU General Public License Version 2.

A copy of this license is included in the COPYING file of this distribution.
Please visit http://www.coin-or.org/CppAD/ for information on other licenses.
-------------------------------------------------------------------------- */

/*
-------------------------------------------------------------------------------
$begin Arithmetic$$
$spell
	Op
	const
$$

$index operator, AD arithmetic$$
$index AD, arithmetic operator$$
$index arithmetic, AD operator$$

$index computed, AD assignment$$
$index assignment, AD computed$$
$index AD, computed assignment$$

$section AD Arithmetic Operators and Computed Assignments$$

$childtable%
	cppad/local/unary_plus.hpp%
	cppad/local/unary_minus.hpp%
	cppad/local/ad_binary.hpp%
	cppad/local/compute_assign.hpp
%$$

$end
-------------------------------------------------------------------------------
*/
# include <cppad/local/unary_plus.hpp>
# include <cppad/local/unary_minus.hpp>
# include <cppad/local/ad_binary.hpp>
# include <cppad/local/compute_assign.hpp>

# endif
