% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simList-accessors.R
\docType{methods}
\name{inputs}
\alias{inputArgs}
\alias{inputArgs,.simList-method}
\alias{inputArgs<-}
\alias{inputArgs<-,.simList-method}
\alias{inputs}
\alias{inputs,.simList-method}
\alias{inputs<-}
\alias{inputs<-,.simList-method}
\alias{outputArgs}
\alias{outputArgs,.simList-method}
\alias{outputArgs<-}
\alias{outputArgs<-,.simList-method}
\alias{outputs}
\alias{outputs,.simList-method}
\alias{outputs<-}
\alias{outputs<-,.simList-method}
\alias{simList-accessors-inout}
\title{Inputs and outputs}
\usage{
inputs(object)

\S4method{inputs}{.simList}(object)

inputs(object) <- value

\S4method{inputs}{.simList}(object) <- value

outputs(object)

\S4method{outputs}{.simList}(object)

outputs(object) <- value

\S4method{outputs}{.simList}(object) <- value

inputArgs(object)

\S4method{inputArgs}{.simList}(object)

inputArgs(object) <- value

\S4method{inputArgs}{.simList}(object) <- value

outputArgs(object)

\S4method{outputArgs}{.simList}(object)

outputArgs(object) <- value

\S4method{outputArgs}{.simList}(object) <- value
}
\arguments{
\item{object}{A \code{simList} simulation object.}

\item{value}{The object to be stored at the slot.}
}
\value{
Returns or sets the value of the slot from the \code{simList} object.
}
\description{
Accessor functions for the \code{inputs} and \code{outputs} slots in a
\code{simList} object.

\code{inputArgs} and \code{outputArgs} are ways to specify any
arguments that are needed for file loading and file saving. This
is still somewhat experimental.
}
\details{
These functions are one of two mechanisms to add the information about which
input files to load in a \code{spades} call and the information about which
output files to save.
The other way is to pass them as arguments to a \code{simInit} call.

Currently, only get and set methods are defined. Subset methods are not.

\code{inputs} accepts a data.frame, with 6 columns.
Currently, only one is required.
See the modules vignette for more details (\code{browseVignettes("SpaDES")}).
Columns are \code{objectName} (required, character),
\code{file} (character),
\code{fun} (character),
\code{package} (character),
\code{interval} (numeric),
and \code{loadTime} (numeric).

\code{outputs} accepts a data.frame, with 5 columns.
Currently, only \code{objectName} is required. #' Columns are:
\code{objectName} (character, required),
\code{file} (character),
\code{fun} (character),
\code{package} (character),
and \code{saveTime} (numeric).
Defaults:
\code{file} is derived from \code{objectName}, but appending the model timeunit and
\code{saveTime} to the file name (separated by underscore, "_"); \code{fun} is
\code{saveRDS}; \code{package} is \code{base}; \code{interval} is NA (i.e., just once);
\code{saveTime} is \code{end(sim)} time, i.e,. once at the end.
See the modules vignette for more details (\code{browseVignettes("SpaDES")}).
}
\note{
The automatic file type handling only adds the correct extension from a given
\code{fun} and \code{package}. It does not do the inverse, from a given extension find the
correct \code{fun} and \code{package}.
}
\examples{
sim <- simInit()

# inputs

test <- 1:10
tmpFile <- file.path(tempdir(), "test.rds")
saveRDS(test, file=tmpFile)
inputs(sim) <- data.frame(file = tmpFile)
inputs(sim) # see that it is not yet loaded, but when it is scheduled to be loaded
sim <- spades(sim)
inputs(sim) # confirm it was loaded

# can put data.frame for inputs directly inside simInit call
sim <- simInit(
   inputs = data.frame(
     files = dir(file.path(tmpFile), full.names = TRUE, pattern = "tif")[1:2],
     functions = "raster",
     package = "raster",
     loadTime = 3,
     stringsAsFactors = FALSE)
   )
sim$test
# Clean up after
file.remove(tmpFile)
# outputs
startFiles <- dir(tempdir(), full.names=TRUE)
tmpFile <- file.path(tempdir(), "temp.rds")
tempObj <- 1:10

# Can add data.frame of outputs directly into simInit call
sim <- simInit(objects=c("tempObj"),
  outputs=data.frame(objectName="tempObj"),
  paths=list(outputPath=tempdir()))
outputs(sim) # To see what will be saved, when, what filename
sim <- spades(sim)
outputs(sim) # To see that it was saved, when, what filename

# Also can add using assignment after a simList object has been made
sim <- simInit(objects=c("tempObj"),
  paths=list(outputPath=tempdir()))
outputs(sim) <- data.frame(objectName = "tempObj", saveTime=1:10)
sim <- spades(sim)
outputs(sim) # To see that it was saved, when, what filename.

# can do highly variable saving
tempObj2 <- paste("val",1:10)
df1 <- data.frame(col1 = tempObj, col2 = tempObj2)
sim <- simInit(objects=c("tempObj", "tempObj2", "df1"),
  paths=list(outputPath=tempdir()))
outputs(sim) = data.frame(
     objectName = c(rep("tempObj",2), rep("tempObj2", 3), "df1"),
     saveTime = c(c(1,4), c(2,6,7), end(sim)),
     fun = c(rep("saveRDS", 5), "write.csv"),
     package = c(rep("base", 5), "utils"),
     stringsAsFactors = FALSE)
# since write.csv has a default of adding a column, x, with rownames, must add additional
#   argument for 6th row in data.frame (corresponding to the write.csv function)
outputArgs(sim)[[6]] <- list(row.names=FALSE)
sim <- spades(sim)
outputs(sim)

# read one back in just to test it all worked as planned
newObj <- read.csv(dir(tempdir(), pattern="second10.csv", full.name=TRUE))
newObj

# using saving with SpaDES-aware methods
# To see current ones SpaDES can do
.saveFileExtensions()

library(raster)
ras <- raster(ncol=4, nrow=5)
ras[] <- 1:20

sim <- simInit(objects=c("ras"),
  paths=list(outputPath=tempdir()))
outputs(sim) = data.frame(
     file="test",
     fun = "writeRaster",
     package = "raster",
     objectName = "ras",
     stringsAsFactors = FALSE)

outputArgs(sim)[[1]] <- list(format="GTiff") # see ?raster::writeFormats
simOut <- spades(sim)
outputs(simOut)
newRas <- raster(dir(tempdir(), full.name=TRUE, pattern=".tif"))
all.equal(newRas, ras) # Should be TRUE

# since write.csv has a default of adding a column, x, with rownames, must add additional
#   argument for 6th row in data.frame (corresponding to the write.csv function)
# Clean up after
endFiles <- dir(tempdir(), full.names=TRUE)
file.remove(endFiles[!(endFiles \%in\% startFiles)])
}
\seealso{
\code{\link{simList-class}},
         \code{\link{simList-accessors-modules}},
         \code{\link{simList-accessors-envir}},
         \code{\link{simList-accessors-events}},
         \code{\link{simList-accessors-objects}},
         \code{\link{simList-accessors-params}},
         \code{\link{simList-accessors-paths}},
         \code{\link{simList-accessors-times}}.
}

