% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module-template.R
\docType{methods}
\name{newModule}
\alias{newModule}
\alias{newModule,character,character,logical,logical-method}
\alias{newModule,character,character,logical,missing-method}
\alias{newModule,character,character,missing,logical-method}
\alias{newModule,character,character,missing,missing-method}
\alias{newModule,character,missing,logical,logical-method}
\alias{newModule,character,missing,logical,missing-method}
\alias{newModule,character,missing,missing,logical-method}
\alias{newModule,character,missing,missing,missing-method}
\alias{newModuleCode}
\alias{newModuleCode,character,character,logical-method}
\alias{newModuleDocumentation}
\alias{newModuleDocumentation,character,character,logical-method}
\alias{newModuleDocumentation,character,character,missing-method}
\alias{newModuleDocumentation,character,missing,logical-method}
\alias{newModuleDocumentation,character,missing,missing-method}
\alias{newModuleTests}
\alias{newModuleTests,character,character,logical-method}
\title{Create new module from template.}
\usage{
newModule(name, path, open, unitTests)

\S4method{newModule}{character,character,logical,logical}(name, path, open,
  unitTests)

\S4method{newModule}{character,missing,logical,logical}(name, open, unitTests)

\S4method{newModule}{character,character,missing,logical}(name, path, unitTests)

\S4method{newModule}{character,missing,missing,logical}(name, unitTests)

\S4method{newModule}{character,character,logical,missing}(name, path, open)

\S4method{newModule}{character,missing,logical,missing}(name, open)

\S4method{newModule}{character,character,missing,missing}(name, path)

\S4method{newModule}{character,missing,missing,missing}(name)

newModuleCode(name, path, open)

\S4method{newModuleCode}{character,character,logical}(name, path, open)

newModuleDocumentation(name, path, open)

\S4method{newModuleDocumentation}{character,character,logical}(name, path, open)

\S4method{newModuleDocumentation}{character,missing,logical}(name, open)

\S4method{newModuleDocumentation}{character,character,missing}(name, path)

\S4method{newModuleDocumentation}{character,missing,missing}(name)

newModuleTests(name, path, open)

\S4method{newModuleTests}{character,character,logical}(name, path, open)
}
\arguments{
\item{name}{Character string. Your module's name.}

\item{path}{Character string. Subdirectory in which to place the new module code file.
The default is the current working directory.}

\item{open}{Logical. Should the new module file be opened after creation?
Default \code{TRUE}.}

\item{unitTests}{Logical. Should the new module include unit test files?
Default \code{TRUE}.
Unit testing relies on the \code{testthat} package.}
}
\value{
Nothing is returned. The new module file is created at
\code{path/name.R}, as well as ancillary files for documentation, citation,
license, readme, and unit tests folder.
}
\description{
Autogenerate a skeleton for a new SpaDES module, a template for a
documentation file, a citation file, a license file, a readme.txt file, and a folder
that contains unit tests information.
The \code{newModuleDocumentation} will not generate the module file, but will
create the other 4 files.
}
\details{
All files will be created within a subfolder named \code{name} within the \code{path}.
}
\note{
On Windows there is currently a bug in RStudio that it doesn't know what editor
to open with \code{file.edit} is called (which is what moduleName does). This will return an error:

\code{Error in editor(file = file, title = title) :}
\code{argument "name" is missing, with no default}

You can just browse to the file and open it manually.
}
\examples{
\dontrun{
  ## create a "myModule" module in the "modules" subdirectory.
  newModule("myModule", "modules")
}
}
\author{
Alex Chubaty and Eliot McIntire

Eliot McIntire and Alex Chubaty

Eliot McIntire

Eliot McIntire and Alex Chubaty
}

