% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mainFunctions.R
\name{getPermutations}
\alias{getPermutations}
\title{Get random permutations of a set of elements}
\usage{
getPermutations(n, nperms)
}
\arguments{
\item{n}{number of elements}

\item{nperms}{number of required permutations}
}
\value{
The function returns:
\itemize{
   \item{ \code{perms}: a matrix with \code{nperms} rows and \code{n} columns, containing the sequence of the ordered elements}
   \item{ \code{all.perms.flag}: \code{1} if the perms array contains the entire collection of permutations, \code{0} otherwise. In the first case, the number of rows of \code{perms} matrix may be less than the number of requested permutations}
   \item{ \code{nperms.act}: the number of permutations returned}
}
}
\description{
The function arranges, in an optimized way, all the elements of a set into a selected number of different sequences (i.e., permutations). If the number of possible orderings is less than the required number, the function returns the collection of all possible permutations.
}
\examples{
sub.perm<-getPermutations(10,100)
all.perm<-getPermutations(3,100)
}
