% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NHPP_functions.R
\name{get_wait_prob}
\alias{get_wait_prob}
\title{Obtain the cumulative probability of the waiting time to the next event}
\usage{
get_wait_prob(last_event, wait_time, hazard, part, scale = FALSE)
}
\arguments{
\item{last_event}{A positive number.  The time at last event.}

\item{wait_time}{A positive number.  The waiting time to the next event.}

\item{hazard}{A vector of positive numbers.  The time-specific hazard rate.}

\item{part}{A vector of positive numbers.  Time partition over which to apply the time-specific hazard rate.}

\item{scale}{Logical. By default \code{scale = FALSE}.  Specifying \code{scale = TRUE} ensures that this function is the CDF of a proper random variable.}
}
\value{
\code{wait_prob} The probability that the waiting time to next event is at least \code{wait_time}.
}
\description{
Determine the cumulative probability of the waiting time associated with a non-homogenous Poisson process, given the time of the last event.
}
\keyword{internal}
