#' SemNeT--package
#' @description Implements several functions for the analysis of semantic
#' networks including partial node bootstraping (Kenett, Anaki, & Faust, 2014),
#' random walk simulation (Kenett & Austerweil, 2016), and a function to compute
#' global network measures. Significance tests and plotting features are also
#' implemented. 
#' 
#' @references
#' Christensen, A. P., Kenett, Y. N., Cotter, K. N., Beaty, R. E., & Silvia, P. J. (2018).
#' Remotely close associations: Openness to experience and semantic memory structure.
#' \emph{European Journal of Personality}, \emph{32}, 480-492.
#' doi:href{https://doi.org/10.1002/per.2157}{10.1002/per.2157}
#' 
#' Kenett, Y. N., Anaki, D., & Faust, M. (2014).
#' Investigating the structure of semantic networks in low and high creative persons.
#' \emph{Frontiers in Human Neuroscience}, \emph{8}, 407.
#' doi:\href{https://doi.org/10.3389/fnhum.2014.00407}{10.3389/fnhum.2014.00407}
#' 
#' Kenett, Y. N., & Austerweil, J. L. (2016).
#' Examining search processes in low and high creative individuals with random walks.
#' In \emph{Paper presented at the proceedings of the 38th annual meeting of the cognitive science society}. Austin, TX.
#' Retrieved from: \href{http://alab.psych.wisc.edu/papers/files/Kenett16CreativityRW.pdf}{http://alab.psych.wisc.edu/papers/files/Kenett16CreativityRW.pdf}
#' 
#' @author Alexander P. Christensen <alexpaulchristensen@gmail.com> & Yoed N. Kenett <yoedkenett@gmail.com>
#' 
#' @importFrom utils packageDescription
#' 
"_PACKAGE"
#> [1] "_PACKAGE"
#SemNeT----