% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Diagnostics.R
\name{checkRareOutcomeAssumption}
\alias{checkRareOutcomeAssumption}
\title{Check if rare outcome assumption is violated}
\usage{
checkRareOutcomeAssumption(
  studyPopulation,
  firstOutcomeOnly = NULL,
  maxPrevalence = 0.1
)
}
\arguments{
\item{studyPopulation}{An object created using the \code{\link[=createStudyPopulation]{createStudyPopulation()}} function.}

\item{firstOutcomeOnly}{Was the analysis restricted to the first outcome only? If left at NULL,
will be determined by whether \code{firstOutcomeOnly} was set to \code{TRUE} when
calling \code{createStudyPopulation()} or whether each person only had one
outcome when pulling the data from the server.}

\item{maxPrevalence}{The maximum allowed prevalence (proportion of people with the outcome)
allowed when restricting to first outcome only.}
}
\value{
A tibble with one row and three columns: \code{outcomeProportion} indicates the proportion of people
having the outcome at least once. \code{firstOutcomeOnly} indicated whether the analysis was restricted
to the first outcome only. \code{rare} is TRUE if the rare outcome assumption is met, or the analysis
was not restricted to the first outcome.
}
\description{
Check if rare outcome assumption is violated
}
\details{
Most SCCS analyses restrict to the first outcome occurrence per person to avoid violating the
assumption that subsequent occurrences are independent. This is fine, as long as the outcome is
rare. According to Farrington et al., the magnitude of the bias from violating this assumption is
0.5p, where p is the prevalence. By default we set the threshold for p at 0.1, corresponding to
at most 5 percent bias.

The prevalence was computed in the \code{getDbSccsData()} function, within the population defined by
the \code{observation_period} table, and restricted to the study period(s) and nesting cohort if
used.
}
\references{
Farrington P, Whitaker H, Ghebremichael-Weldeselassie Y, Self-Controlled Case Series Studies: A
Modelling Guide with R, CRC Press, 2018
}
