% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{climatology_threshold_exceedence}
\alias{climatology_threshold_exceedence}
\title{Get climatological prediction for exceedence probabilities.}
\usage{
climatology_threshold_exceedence(
  obs_dt,
  o = "prec",
  by = setdiff(dimvars(obs_dt), "year"),
  thresholds = c(200, 300, 350, 400)
)
}
\arguments{
\item{obs_dt}{Data table containing observations.}

\item{o}{column name of the observation. Mostly observed precipitation in mm.}

\item{by}{By which columns should be grouped?}

\item{thresholds}{vector of thresholds for which the exceedence probabilities should be derived.}
}
\value{
Data table with the climatological probabilities of exceedence for the provided thresholds.
}
\description{
The climatological prediction for exceedence probabilities is the fraction of observed years where the observation exceeded the threshold.
It's calculated from leave-one-year-out climatology.
}
\examples{
\donttest{
dt = climatology_threshold_exceedence(chirps_monthly)
}

}
