% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_deadata_stoch.R
\name{make_deadata_stoch}
\alias{make_deadata_stoch}
\title{make_deadata_stoch}
\usage{
make_deadata_stoch(datadea = NULL,
          var_input = NULL,
          var_output = NULL,
          cov_input = NULL,
          cov_output = NULL,
          cov_II = NULL,
          cov_OO = NULL,
          cov_IO = NULL,
          cov_matrix = NULL)
}
\arguments{
\item{datadea}{The \code{deadata} object.}

\item{var_input}{A matrix of size \code{m} x \code{n}, where \code{m} is the
number of inputs and \code{n} is the number of DMUs. It contains the variances
of each input of each DMU, such that \code{var_input[i, j]} is the variance
of the input \code{i} of DMU \code{j}.
Use this parameter if all covariances are 0.}

\item{var_output}{A matrix of size \code{s} x \code{n}, where \code{s} is the
number of outputs and \code{n} is the number of DMUs. It contains the variances
of each output of each DMU, such that \code{var_output[r, j]} is the variance
of the output \code{r} of DMU \code{j}.
Use this parameter if all covariances are 0.}

\item{cov_input}{An array of size \code{m} x \code{n} x \code{n} containing
the covariances of each input between DMUs, such that
\code{cov_input[i, j, k]} is the covariance between the input \code{i}
of DMU \code{j} and the input \code{i} of DMU \code{k}. The corresponding
variances are in the diagonal of each \code{n} x \code{n} submatrix. Since
these submatrices are supposed to be symmetric, only values above the diagonal
are read in order to reconstruct the symmetric submatrices, ignoring values
below the diagonal.
Use this parameter if covariances between different inputs are 0.}

\item{cov_output}{An array of size \code{s} x \code{n} x \code{n} containing
the covariances of each output between DMUs, such that
\code{cov_output[r, j, k]} is the covariance between the output \code{r}
of DMU \code{j} and the output \code{r} of DMU \code{k}. The corresponding
variances are in the diagonal of each \code{n} x \code{n} submatrix. Since
these submatrices are supposed to be symmetric, only values above the diagonal
are read in order to reconstruct the symmetric submatrices, ignoring values
below the diagonal.
Use this parameter if covariances between different outputs are 0.}

\item{cov_II}{An array of size \code{m} x \code{m} x \code{n} x \code{n}
containing the covariances between inputs and between DMUs, such that
\code{cov_II[i1, i2, j, k]} is the covariance between the input \code{i1}
of DMU \code{j} and the input \code{i2} of DMU \code{k}. For the input \code{i},
the corresponding variances are in the diagonal of the \code{n} x \code{n}
submatrices of the form \code{cov_II[i, i, , ]}. Since
these submatrices are supposed to be symmetric, only values above the diagonal
are read in order to reconstruct the symmetric submatrices, ignoring values
below the diagonal.
Moreover, since \code{cov_II[i2, i1, , ]} is the transpose of \code{cov_II[i1, i2, , ]},
only submatrices \code{cov_II[i1, i2, , ]} with \code{i1 <= i2} are necessary, ignoring
those with \code{i1 > i2}.
Use this parameter if covariances between inputs are nonzero.}

\item{cov_OO}{An array of size \code{s} x \code{s} x \code{n} x \code{n} containing
the covariances between outputs and between DMUs, such that
\code{cov_OO[r1, r2, j, k]} is the covariance between the output \code{r1}
of DMU \code{j} and the output \code{r2} of DMU \code{k}. For the output \code{r},
the corresponding variances are in the diagonal of the \code{n} x \code{n}
submatrices of the form \code{cov_OO[r, r, , ]}. Since
these submatrices are supposed to be symmetric, only values above the diagonal
are read in order to reconstruct the symmetric submatrices, ignoring values
below the diagonal.
Moreover, since \code{cov_OO[r2, r1, , ]} is the transpose of \code{cov_OO[r1, r2, , ]},
only submatrices \code{cov_OO[r1, r2, , ]} with \code{r1 <= r2} are necessary, ignoring
those with \code{r1 > r2}.
Use this parameter if covariances between outputs are nonzero.}

\item{cov_IO}{An array of size \code{m} x \code{s} x \code{n} x \code{n} containing
the covariances between inputs and outputs, and between DMUs, such that
\code{cov_IO[i, r, j, k]} is the covariance between the input \code{i}
of DMU \code{j} and the output \code{r} of DMU \code{k}.
Use this parameter if covariances between inputs and outputs are nonzero.}

\item{cov_matrix}{A matrix of size \code{n(m+s)} x \code{n(m+s)} following the
notation of Cooper et al. (1998). Since this matrix is supposed to be symmetric,
only values above the diagonal are read, ignoring values below the diagonal.}
}
\value{
An object of class \code{deadata_stoch}.
}
\description{
This function creates, from a \code{deadata} object, a
\code{deadata_stoch} object by adding the corresponding covariance matrices.
These objects are prepared to be passed to a modelstoch_* function.

We consider \eqn{\mathcal{D}=\left\{ \textrm{DMU}_1, \ldots ,\textrm{DMU}_n \right\} }
a set of \eqn{n} DMUs with \eqn{m} stochastic inputs and \eqn{s} stochastic outputs.
Matrices \eqn{\tilde{X}=(\tilde{x}_{ij})} and \eqn{\tilde{Y}=(\tilde{y}_{rj})}
are the input and output data matrices, respectively, where \eqn{\tilde{x}_{ij}}
and \eqn{\tilde{y}_{rj}} represent the \eqn{i}-th input and \eqn{r}-th output
of the \eqn{j}-th DMU. Moreover, we denote by \eqn{X=(x_{ij})} and \eqn{Y=(y_{rj})}
their expected values.
We suppose that \eqn{\tilde{x}_{ij}} and \eqn{\tilde{y}_{rj}} follow a multivariate
probability distribution with means \eqn{E(\tilde{x}_{ij})=x_{ij}}, \eqn{E(\tilde{y}_{rj})=y_{rj}}
and covariance matrix
\deqn{\Delta = \begin{pmatrix}
\Delta ^{II}_{11} & \cdots & \Delta ^{II}_{1m} & \Delta ^{IO}_{11} & \cdots & \Delta ^{IO}_{1s} \\
\vdots & & \vdots & \vdots & & \vdots \\
\Delta ^{II}_{m1} & \cdots & \Delta ^{II}_{mm} & \Delta ^{IO}_{m1} & \cdots & \Delta ^{IO}_{ms} \\ \\
\Delta ^{OI}_{11} & \cdots & \Delta ^{OI}_{1m} & \Delta ^{OO}_{11} & \cdots & \Delta ^{OO}_{1s} \\
\vdots & & \vdots & \vdots & & \vdots \\
\Delta ^{OI}_{s1} & \cdots & \Delta ^{OI}_{sm} & \Delta ^{OO}_{s1} & \cdots & \Delta ^{OO}_{ss} \\
\end{pmatrix}_{n(m+s)\times n(m+s)}}
where \eqn{\Delta ^{II}_{ik}}, \eqn{\Delta ^{OO}_{rp}}, \eqn{\Delta ^{IO}_{ir}}
and \eqn{\Delta ^{OI}_{ri}} are \eqn{n\times n} matrices, for \eqn{1\leq i,k\leq m}
and \eqn{1\leq r,p\leq s}, such that
\deqn{\left( \Delta ^{II}_{ik}\right) _{jq}=\mathrm{Cov}(\tilde{x}_{ij}, \tilde{x}_{kq}),}
\deqn{\left( \Delta ^{OO}_{rp}\right) _{jq}=\mathrm{Cov}(\tilde{y}_{rj}, \tilde{y}_{pq}),}
\deqn{\left( \Delta ^{IO}_{ir}\right) _{jq}=\left( \Delta ^{OI}_{ri}\right) _{qj}
=\mathrm{Cov}(\tilde{x}_{ij}, \tilde{y}_{rq}),}
with \eqn{1\leq j,q\leq n}.

- If we have the covariances matrix in the general form above, it can be introduced
directly by parameter \code{cov_matrix}. Since this matrix is supposed to be
symmetric, only values above the diagonal are read, ignoring values below the diagonal.

- Alternatively, we can introduce the covariances matrix using parameters \code{cov_II},
\code{cov_OO} and \code{cov_IO}, that are 4-dimensional arrays of size \eqn{m\times
m\times n\times n}, \eqn{s\times s\times n\times n} and \eqn{m\times s\times n\times n},
respectively, such that
\deqn{\texttt{cov\_II[i, k, , ]}=\Delta ^{II}_{ik},}
\deqn{\texttt{cov\_OO[r, p, , ]}=\Delta ^{OO}_{rp},}
\deqn{\texttt{cov\_IO[i, r, , ]}=\Delta ^{IO}_{ir},}
for \eqn{1\leq i,k\leq m} and \eqn{1\leq r,p\leq s}. Since matrices \eqn{\Delta ^{II}_{ii}} and \eqn{\Delta
^{OO}_{rr}} are supposed to be symmetric, only values above the diagonal are
read, ignoring values below the diagonal. Moreover, since \eqn{\Delta ^{II}_{ki}}
is the transpose of \eqn{\Delta ^{II}_{ik}}, and \eqn{\Delta ^{OO}_{pr}} is
the transpose of \eqn{\Delta ^{OO}_{rp}}, only matrices \eqn{\Delta ^{II}_{ik}}
and \eqn{\Delta ^{OO}_{rp}} with \eqn{i\leq k} and \eqn{r\leq p} are necessary,
ignoring those with \eqn{i>k} and \eqn{r>p}.

- If covariances between different inputs/outputs are zero, we can make use of
parameters \code{cov_input} and \code{cov_output}, that are arrays of size
\eqn{m\times n\times n} and \eqn{s\times n\times n}, respectively, such that
\deqn{\texttt{cov\_input[i, , ]}=\Delta ^{II}_{ii},}
\deqn{\texttt{cov\_output[r, , ]}=\Delta ^{OO}_{rr},}
for \eqn{1\leq i\leq m} and \eqn{1\leq r\leq s}. By symmetry of \eqn{\Delta
^{II}_{ii}} and \eqn{\Delta ^{OO}_{rr}}, only values above the diagonal are
read, ignoring values below the diagonal.

- Finally, if all the variables are independent then the covariances matrix is
diagonal. Hence, we might use parameters \code{var_input} and \code{var_output},
that are matrices of size \eqn{m\times n} and \eqn{s\times n}, respectively,
such that
\deqn{\texttt{var\_input[i, j]}=\mathrm{Var}\left( \tilde{x}_{ij}\right) ,}
\deqn{\texttt{var\_output[r, j]}=\mathrm{Var}\left( \tilde{y}_{rj}\right) ,}
for \eqn{1\leq i\leq m}, \eqn{1\leq r\leq s} and \eqn{1\leq j\leq n}.
}
\examples{
# Example 1
library(deaR)
data("Coll_Blasco_2006")
ni <- 2 # number of inputs
no <- 2 # number of outputs
data_example <- make_deadata(datadea = Coll_Blasco_2006,
                             ni = ni,
                             no = no)
nd <- length(data_example$dmunames) # number of DMUs
# All variances are 1.
var_input <- matrix(1, nrow = ni, ncol = nd)
var_output <- matrix(1, nrow = no, ncol = nd)
data_stoch <- make_deadata_stoch(datadea = data_example,
                                 var_input = var_input,
                                 var_output = var_output)
# All covariances are 1.
cov_input <- array(1, dim = c(ni, nd, nd))
cov_output <- array(1, dim = c(no, nd, nd))
data_stoch2 <- make_deadata_stoch(datadea = data_example,
                                  cov_input = cov_input,
                                  cov_output = cov_output)

# Example 2. Deterministic data with one stochastic input,
# from El-Demerdash et al. (2013).
library(deaR)
dmunames <- c("A", "B", "C")
nd <- length(dmunames) # Number of DMUs
inputnames <- c("Professors", "Budget")
ni <- length(inputnames) # Number of Inputs
outputnames <- c("Diplomas", "Bachelors", "Masters")
no <- length(outputnames) # Number of Outputs
X <- matrix(c(5, 14, 8, 15, 7, 12),
            nrow = ni, ncol = nd, dimnames = list(inputnames, dmunames))
Y <- matrix(c(9, 4, 16, 5, 7, 10, 4, 9, 13),
            nrow = no, ncol = nd, dimnames = list(outputnames, dmunames))
datadea <- make_deadata(inputs = X,
                        outputs = Y)
covX <- array(0, dim = c(2, 3, 3))
# The 2nd input is stochastic.
# Since the corresponding 3x3 covariances matrix is symmetric, only values
# above the diagonal are necessary.
covX[2, 1, ] <- c(1.4, 0.9, 0.6)
covX[2, 2, 2:3] <- c(1.5, 0.7)
covX[2, 3, 3] <- 1.2
# Alternatively (note that values below the diagonal are ignored).
covX[2, , ] <- matrix(c(1.4, 0.9, 0.6, 0, 1.5, 0.7, 0, 0, 1.2),
                      byrow = TRUE)
datadea_stoch <- make_deadata_stoch(datadea,
                                    cov_input = covX)

# Example 3. 5 random observations of 3 DMUs with 2 inputs and 2 outputs.
library(deaR)
# Generate random observations.
input1 <- data.frame(I1D1 = rnorm(5, mean = sample(5:10, 1)),
                     I1D2 = rnorm(5, mean = sample(5:10, 1)),
                     I1D3 = rnorm(5, mean = sample(5:10, 1)))
input2 <- data.frame(I2D1 = rnorm(5, mean = sample(5:10, 1)),
                     I2D2 = rnorm(5, mean = sample(5:10, 1)),
                     I2D3 = rnorm(5, mean = sample(5:10, 1)))
output1 <- data.frame(O1D1 = rnorm(5, mean = sample(5:10, 1)),
                      O1D2 = rnorm(5, mean = sample(5:10, 1)),
                      O1D3 = rnorm(5, mean = sample(5:10, 1)))
output2 <- data.frame(O2D1 = rnorm(5, mean = sample(5:10, 1)),
                      O2D2 = rnorm(5, mean = sample(5:10, 1)),
                      O2D3 = rnorm(5, mean = sample(5:10, 1)))
# Generate deadata with means of observations.
inputs <- matrix(mapply(mean, cbind(input1, input2)),
                 nrow = 2,
                 ncol = 3,
                 byrow = TRUE,
                 dimnames = list(c("I1", "I2"), c("D1", "D2", "D3")))
outputs <- matrix(mapply(mean, cbind(output1, output2)),
                  nrow = 2,
                  ncol = 3,
                  byrow = TRUE,
                  dimnames = list(c("O1", "O2"), c("D1", "D2", "D3")))
datadea <- make_deadata(inputs = inputs,
                        outputs = outputs)
# Generate covariances matrix cov_matrix.
cov_matrix <- cov(cbind(input1, input2, output1, output2))
# Generate deadata_stoch
datadea_stoch <- make_deadata_stoch(datadea,
                                    cov_matrix = cov_matrix)

}
\references{
Cooper, W.W.; Huang, Z.; Lelas, V.; Li, S.X.; Olesen, O.B. (1998). “Chance
Constrained Programming Formulations for Stochastic Characterizations of
Efficiency and Dominance in DEA", Journal of Productivity Analysis, 9, 53-79.

El-Demerdash, B.E.; El-Khodary, I.A.; Tharwat, A.A. (2013). "Developing a Stochastic
Input Oriented Data Envelopment Analysis (SIODEA) Model", International Journal
of Advanced Computer Science and Applications, Vol.4, No. 4, 40-44.
}
\author{
\strong{Vicente Bolós} (\email{vicente.bolos@uv.es}).
\emph{Department of Business Mathematics}

\strong{Rafael Benítez} (\email{rafael.suarez@uv.es}).
\emph{Department of Business Mathematics}

\strong{Vicente Coll-Serrano} (\email{vicente.coll@uv.es}).
\emph{Quantitative Methods for Measuring Culture (MC2). Applied Economics.}

University of Valencia (Spain)
}
