% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_circos_karyotype.R
\name{write_circos_karyotype}
\alias{write_circos_karyotype}
\title{write_circos_karyotype}
\usage{
write_circos_karyotype(df, chromosome_grouping = FALSE,
  band_grouping = FALSE, start_position, end_position,
  file_name = "karyotype.txt", file_path = NULL)
}
\arguments{
\item{df}{A database to draw Circos data from}

\item{chromosome_grouping}{A column defining the circos chromosomes. Passed as column index or "column name"}

\item{band_grouping}{A column defining the circos bands. Passed as column index or "column name"}

\item{start_position}{A column defining the lineage start positions. Passed as column index or "column name"}

\item{end_position}{A column defining the lineage start positions. Passed as column index or "column name"}

\item{file_name}{The desired file name. Defaults to karyotype.txt in the current working directory}

\item{file_path}{The desired file path destination folder. Defaults to NULL}
}
\value{
Writes a Circos-compatible karyotype file to the desired directory
}
\description{
A function that takes a data frame in the format of those returned by the `make_circos_df_*` functions, and writes a "karyotype"
file for Circos plotting
}
\examples{

df <- data.frame(chrom = c(1, 1, 2, 2), band = c(1, 2, 1, 2), start = c(1, 5, 1, 8),
end = c(5, 10, 8, 13), n = c(5, 5, 8, 5))

write_circos_karyotype(df = df, chromosome_grouping = "chrom", band_grouping = "band",
start_position = "start", end_position = "end",
file_name = "karyotype.txt", file_path = tempdir())
}
\author{
Matthew Woodruff, Emory University
}
