% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-reps.R
\name{get_reps}
\alias{get_reps}
\title{Get Reps}
\usage{
get_reps(perc_1RM, method = "RIR", model = "epley", ...)
}
\arguments{
\item{perc_1RM}{Numeric vector. \%1RM used (use 0.5 for 50 perc, 0.9 for 90 perc)}

\item{method}{Character vector. Default is "RIR". Other options are
"DI", "RelInt", "\%MR"}

\item{model}{Character vector. Default is "epley". Other options are
"modified epley", "linear"}

\item{...}{Forwarded to selected \code{adj_reps} function}
}
\value{
Numeric vector Predicted repetitions
}
\description{
Function \code{get_reps} represent a wrapper function. This function is the
reverse version of the \code{\link{get_perc_1RM}} function. Use it when
you want to estimate number of repetitions to be used when using the
known \%1RM and level of adjustment
}
\examples{
get_reps(0.75)

# # Use ballistic adjustment (this implies doing half the reps)
get_reps(0.75, mfactor = 2)

# Use \%MR adjustment method
get_reps(0.75, "\%MR", adjustment = 0.8)

# Use linear model with use defined klin values
get_reps(0.75, "\%MR", model = "linear", adjustment = 0.8, klin = 36)
}
