% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hierarchies_as_vars.R
\name{hierarchies_as_vars}
\alias{hierarchies_as_vars}
\title{Hierarchies coded as variables}
\usage{
hierarchies_as_vars(
  hierarchies,
  name_function = function(name, level) paste0(name, "_level_", level),
  single_vars = FALSE,
  from_dummy = NA,
  dummy_reorder = TRUE,
  combine_vars = TRUE,
  ...
)
}
\arguments{
\item{hierarchies}{List of hierarchies in the same format as input to \code{\link{AutoHierarchies}}}

\item{name_function}{A function defining how to name all columns except the first.
The input consists of the hierarchy name (identical to the first column’s name, \code{name})
and the column number minus 1 (\code{level}).}

\item{single_vars}{When \code{TRUE}, a single variable is created for all codes except the input codes.}

\item{from_dummy}{Logical value indicating the method for handling hierarchies.
\itemize{
\item When \code{TRUE}, the algorithm uses dummy-coded hierarchies.
\item When \code{FALSE}, the algorithm works directly on hierarchies standardized by \code{AutoHierarchies}, often resulting in well-structured output variables.
\item When \code{NA} (default), the algorithm first attempts the \code{FALSE} method; if not feasible, it falls back to the \code{TRUE} method.
}}

\item{dummy_reorder}{When \code{TRUE}, dummy-coded hierarchies are reordered to potentially improve the structure of output variables.}

\item{combine_vars}{When \code{TRUE}, an algorithm is applied to potentially reduce the number of output variables needed.}

\item{...}{Additional parameters passed to \code{\link{AutoHierarchies}}}
}
\value{
Named list of data frames
}
\description{
The hierarchical relations are stored as minimal datasets
}
\examples{
# Examples based on those from AutoHierarchies
# You may also try converting other examples from AutoHierarchies

z <- SSBtoolsData("sprt_emp_withEU")
year_formula <- c("y_14 = 2014", "y_15_16 = y_all - y_14", "y_all = 2014 + 2015 + 2016")
geo_dim_list <- FindDimLists(z[, c("geo", "eu")], total = "Europe")[[1]]
age_hierarchy <- SSBtoolsData("sprt_emp_ageHier")

hierarchies_as_vars(list(age = age_hierarchy, geo = geo_dim_list, year = year_formula))
hierarchies_as_vars(list(age = age_hierarchy, geo = geo_dim_list, year = year_formula), 
                    singleVars = TRUE)
                    
# NAs are included in data when necessary
hierarchies_as_vars(list(f = c("AB = A + B", "AC = A + C", "CD = C + D", "ABCD = AB + CD")))                     
                    
}
\seealso{
\code{\link{vars_to_hierarchies}}
}
