% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RowGroups.R
\name{RowGroups}
\alias{RowGroups}
\title{Create numbering according to unique rows}
\usage{
RowGroups(x, returnGroups = FALSE, returnGroupsId = FALSE)
}
\arguments{
\item{x}{Data frame or matrix}

\item{returnGroups}{When TRUE unique rows are returned}

\item{returnGroupsId}{When TRUE Index of unique rows are returned}
}
\value{
A vector with the numbering or, according to the arguments,
a list with more output.
}
\description{
Create numbering according to unique rows
}
\examples{
a <- data.frame(x = c("a", "b"), y = c("A", "B", "A"), z = rep(1:4, 3))
RowGroups(a)
RowGroups(a, TRUE)
RowGroups(a[, 1:2], TRUE, TRUE)
RowGroups(a[, 1, drop = FALSE], TRUE)
}
\author{
Øyvind Langsrud
}
