% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SRTcci.R
\name{srtsim_cci_ref}
\alias{srtsim_cci_ref}
\title{Generate Data with Cell-Cell Interaction Under Reference-Based Mode}
\usage{
srtsim_cci_ref(
  EstParam = NULL,
  numGene = 1000,
  location_in,
  region_cell_map,
  fc = 3,
  LR_in,
  sim_seed = 1,
  numKNN = 4,
  numSingleCellType = 2000
)
}
\arguments{
\item{EstParam}{A list of estimated parameters from srtsim_fit function, EstParam slot if the simSRT object.}

\item{numGene}{An integer specifying the number of genes in the synthetic data, default is 1000}

\item{location_in}{A dataframe with x, y, and region_label}

\item{region_cell_map}{A dataframe specifying the cell type proportion in each region. Row: region,Column: cell type.}

\item{fc}{A number specifying effect size for ligand-receptor pairs that mediate the cel-cell communication, default is 3}

\item{LR_in}{A dataframe specifying ligand and receptor pairs, containing four columns: protein_a, protein_b, celltypeA, and celltype B}

\item{sim_seed}{A number for reproducible purpose}

\item{numKNN}{A number specifying number of nearest neighbors with elevated gene expressin levels, default is 4}

\item{numSingleCellType}{A number specifying number of spots in the background pool. Gene expression count are then sampled from this background pool.}
}
\value{
Returns a SRTsim object with a newly generated count matrix and correspoding parameters
}
\description{
Generate Data with Cell-Cell Interaction Under Reference-Based Mode
}
