% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funMarkovChain.R
\name{generateMCPrediction}
\alias{generateMCPrediction}
\title{generateMCPrediction}
\usage{
generateMCPrediction(
  testData,
  models,
  startSimulation = "2020-01-22",
  write = FALSE
)
}
\arguments{
\item{testData}{'data.frame':    obs. of  3 variables:
\describe{
    \item{\code{ForecastId}}{int  1 2 3 4 5 6 7 8 9 10 ...}
    \item{\code{Region}}{Factor w/ 313 levels "Afghanistan/",..: 1 1 1 1 1 1 1 1 1 1 ...}
    \item{\code{Date}}{Date, format: "2020-04-02" "2020-04-03" "2020-04-04" "2020-04-05" ...}
}}

\item{models}{'data.frame':    obs. of  7 variables:
\describe{
    \item{\code{p}}{num  [0;1] proportion of confirmed cases}
    \item{\code{beta}}{num  13.8 13.8 16.3 11.5 29.2 ...}
    \item{\code{gamma}}{num  13.8 13.8 16.3 11.5 29.2 ...}
    \item{\code{CFR}}{num  0.14 0.14 0.2319 0.0312 0.0705 ...}
    \item{\code{cost}}{num  658 256 1207 1091 300 ...}
    \item{\code{region}}{ chr, e.g., "Afghanistan/" "Albania/" "Algeria/" "Andorra/" ...}
}}

\item{startSimulation}{chr start of the simulation period, e.g., "2020-01-22".
startSimulation must be at or before the Date from testData. Simulations can
start earlier, because some use R=0. This enables a warm-up period.}

\item{write}{logical. Default \code{FALSE}. If \code{TRUE}, results are written to the file \code{submit.csv}.}
}
\value{
returns data.frame with obs. of the following 3 variables:
\describe{
   \item{\code{ForecastId}}{int: Forecast Id taken from the \code{regionTest} data set.}
   \item{\code{ConfirmedCases}}{num: Cumulative number of confirmed cases.}
   \item{\code{Fatalities}}{num: Cumulative number of fatalities.}
}
}
\description{
Predict results on test data using the tuned MarkovChain mode.
Result has the required data format for a submission to the Kaggle
COVID-19 challenge.
}
\details{
Output from \code{\link{parseTunedRegionModel}} is processed.
}
\examples{
\donttest{
require("SimInf")
require("SPOT")
data <- preprocessInputData(regionTrain, regionPopulation)
testData <- preprocessTestData(regionTest)
## Select the first region:
testData <- testData[testData$Region==levels(testData$Region)[1], ]
testData$Region <- droplevels(testData$Region)
## Very small number of function evaluations:
n <- 6
res <- lapply(data[1], tuneRegionModel, pops=NULL,
control=list(funEvals=n, designControl=list(size=5), model = buildLM))
parsedList <- parseTunedRegionModel(res)
pred <- generateMCPrediction(testData = testData, models = parsedList$models, write = FALSE)
}
}
