% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildKrigingDACE.R
\name{dacePrepareFit}
\alias{dacePrepareFit}
\title{Prepare DACE fit}
\usage{
dacePrepareFit(S, Y, nugget, regr = regpoly0, corr = corrnoisykriging)
}
\arguments{
\item{S}{known design points. That is, a matrix with \code{n} rows (for each point) and \code{dim} columns (for each dimension).}

\item{Y}{vector of observations at known design points of length \code{n}.}

\item{nugget}{Value for nugget. Default is -1, which means the nugget will be optimized during MLE.}

\item{regr}{Regression function to be used: \code{\link{regpoly0}} (default), \code{\link{regpoly1}}, \code{\link{regpoly2}}. Can be a custom user function.}

\item{corr}{Correlation function to be used: \code{\link{corrnoisykriging}} (default), \code{\link{corrkriging}}, \code{\link{corrnoisygauss}}, \code{\link{corrgauss}}, \code{\link{correxp}}, \code{\link{correxpg}}, \code{\link{corrlin}}, \code{\link{corrcubic}},\code{\link{corrspherical}},\code{\link{corrspline}}. Can also be user supplied (if in the right form).}
}
\value{
a list with several model or problem specific settings and parameters
}
\description{
Prepares a list with relevant model options and settings based on user choice and problem setup.
}
\seealso{
\code{\link{buildKrigingDACE}}
}
\author{
The authors of the original DACE Matlab code are Hans Bruun Nielsen, Soren Nymand Lophaven and Jacob Sondergaard. \cr
Extension of the Matlab by Tobias Wagner \email{wagner@isf.de}. \cr 
Porting and adaptation to R and further extensions by Martin Zaefferer \email{martin.zaefferer@fh-koeln.de}.
}
\keyword{internal}
