% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildRanger.R
\name{buildRanger}
\alias{buildRanger}
\title{ranger Interface}
\usage{
buildRanger(x, y, control = list())
}
\arguments{
\item{x}{matrix of input parameters. Rows for each point, columns for each parameter.}

\item{y}{one column matrix of observations to be modeled.}

\item{control}{list of control parameters. These are all configuration parameters 
of the \code{ranger} function, and will be passed on to it.}
}
\value{
an object of class \code{"spotRanger"}, with a \code{predict} method and a \code{print} method.
}
\description{
This is a simple wrapper for the \code{ranger} function from the \code{ranger} package.
The purpose of this function is to provide an interface as required by SPOT, to enable
modeling and model-based optimization with \code{ranger}.
}
\examples{
\dontrun{
## Create a simple training data set
testfun <- function (x) x[1]^2
x <- cbind(sort(runif(30)*2-1))
y <- as.matrix(apply(x,1,testfun))
## test data:
xt <- cbind(sort(runif(3000)*2-1))
## Example with default model (standard randomforest)
fit <- buildRanger(x,y)
yt <- predict(fit,data.frame(x=xt))
plot(xt,yt$y,type="l")
points(x,y,col="red",pch=20)
## Example with extratrees, an interpolating model
fit <- buildRanger(x,y,
                   control=list(rangerArguments = 
                                list(replace = F,
                                   sample.fraction=1,
                                   min.node.size = 1,
                                   splitrule = "extratrees")))
yt <- predict(fit,data.frame(x=xt))
plot(xt,yt$y,type="l")
points(x,y,col="red",pch=20)
}
}
