% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/designLHD.R
\name{designLHDNorm}
\alias{designLHDNorm}
\title{Normalized LHD Design}
\usage{
designLHDNorm(dim, size, calcMinDistance = FALSE, nested = NULL,
  inequalityConstraint = NULL)
}
\arguments{
\item{dim}{number, dimension of the problem (will be no. of columns of the result matrix)}

\item{size}{number of points with that dimension needed. (will be no. of rows of the result matrix).}

\item{calcMinDistance}{Boolean to indicate whether a minimal distance should be calculated.}

\item{nested}{nested design to be considered during distance calculation.}

\item{inequalityConstraint}{inequality constraint function, smaller zero for infeasible points. Used to replace infeasible points with random points. Has to evaluate points in interval [0;1].}
}
\value{
list \code{L}  \cr
- \code{L} consists of a matrix \code{L$design} and (if required) a minimal distance \code{L$minDistance}
}
\description{
Produces a normalized design and calculates the minimal distance 
if required.
A design  is a matrix with \code{dim} columns and \code{size} rows.
Distance can be calculated with respect to a fixed, nested design.
}
\seealso{
This function is used as a basis for \code{\link{designLHD}}.
}
\author{
Original code by Christian Lasarczyk, adaptations by Martin Zaefferer
}
\keyword{internal}
