% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/spotPredictDace.R
\name{daceBuilder}
\alias{daceBuilder}
\title{Build DACE model}
\usage{
daceBuilder(parameters, objectives, startTheta, tol = 1e-06, budget = 100,
  regr = regpoly0, corr = corrnoisykriging, nugget = -1,
  algtheta = "optim-L-BFGS-B")
}
\arguments{
\item{parameters}{known design points. That is, a matrix with \code{n} rows (for each point) and \code{dim} columns (for each dimension).}

\item{objectives}{vector of observations at known design points of length \code{n}.}

\item{startTheta}{vector which contains initial guess for model parameters theta. Initial guess will be set depending on correlation function if this vector is missing.}

\item{tol}{Tolerance stopping criterion for the simplex MLE. Default is \code{1e-6}.}

\item{budget}{Number of Likelihood evaluations, as a stopping criterion for the simplex MLE. Default is \code{Inf}. The value will be multiplied with the length of the model parameter vector to be optimized.}

\item{regr}{Regression function to be used: \code{\link{regpoly0}} (default), \code{\link{regpoly1}}, \code{\link{regpoly2}}. Can be a custom user function.}

\item{corr}{Correlation function to be used: \code{\link{corrnoisykriging}} (default), \code{\link{corrkriging}}, \code{\link{corrnoisygauss}}, \code{\link{corrgauss}}, \code{\link{correxp}}, \code{\link{correxpg}}, \code{\link{corrlin}}, \code{\link{corrcubic}},\code{\link{corrspherical}},\code{\link{corrspline}}. Can also be user supplied (if in the right form).}

\item{nugget}{Value for nugget. Default is -1, which means the nugget will be optimized during MLE. Else it can be fixed in a range between 0 and 1.}

\item{algtheta}{algorithm used to find theta, default is \code{"optim-L-BFGS-B"}. Else, any from the list of possible \code{method} values in \code{\link{spotOptimizationInterface}} can be chosen.}
}
\value{
returns a list with the following elements:
			\item{\code{model}}{ Again a list, containing model parameters}
			\item{\code{like}}{ Likelihood value}
			\item{\code{theta}}{activity parameters theta (vector)}
			\item{\code{p}}{exponents p (vector)}
			\item{\code{lambda}}{nugget value (numeric)}
			\item{\code{nevals}}{ Number of iterations during MLE}
}
\description{
This Kriging meta model is based on DACE (Design and Analysis of Computer Experiments).
It allows to choose different regression and correlation models. The optimization of model parameters
is by default done with a bounded simplex method from the \code{nloptr} package.
}
\examples{
## Create design points
x = cbind(runif(20)*15-5,runif(20)*15)
## Compute observations at design points (for Branin function)
y = apply(x,1,spotBraninFunction)
## Create model with default settings
fit = daceBuilder(x,y)
## Print model parameters
print(fit)
## Create with different regression and correlation functions
fit = daceBuilder(x,y,regr=regpoly2,corr=corrspline)
## Print model parameters
print(fit)
}
\author{
The authors of the original DACE Matlab toolbox \url{http://www2.imm.dtu.dk/~hbni/dace/}
are Hans Bruun Nielsen \email{hbn@imm.dtu.dk}, Soren Nymand Lophaven and Jacob Sondergaard. \cr
Extension of the Matlab code by Tobias Wagner \email{wagner@isf.de}. \cr
Porting and adaptation to R and further extensions by Martin Zaefferer \email{martin.zaefferer@fh-koeln.de}.
}
\references{
S.~Lophaven, H.~Nielsen, and J.~Sondergaard.
{DACE---A Matlab Kriging Toolbox}.
Technical Report IMM-REP-2002-12, Informatics and Mathematical
Modelling, Technical University of Denmark, Copenhagen, Denmark, 2002.
}
\seealso{
\code{\link{spotPredictDace}} \code{\link{dacePredictor}}
}

