% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/features_09_major_revisions.R
\name{claim_majRev}
\alias{claim_majRev}
\alias{claim_majRev_freq}
\alias{claim_majRev_time}
\alias{claim_majRev_size}
\title{Major Revisions of Incurred Loss}
\usage{
claim_majRev_freq(
  claims,
  rfun,
  paramfun,
  frequency_vector = claims$frequency_vector,
  claim_size_list = claims$claim_size_list,
  ...
)

claim_majRev_time(
  claims,
  majRev_list,
  rfun,
  paramfun,
  claim_size_list = claims$claim_size_list,
  settlement_list = claims$settlement_list,
  payment_delay_list = claims$payment_delay_list,
  ...
)

claim_majRev_size(majRev_list, rfun, paramfun, ...)
}
\arguments{
\item{claims}{an \code{\link[SynthETIC]{claims}} object containing all the
simulated quantities (other than those related to incurred loss), see
\code{\link[SynthETIC]{claims}}.}

\item{rfun}{optional alternative random sampling function for:
\itemize{
\item \code{claim_majRev_freq}: the number of major revisions;
\item \code{claim_majRev_time}: the epochs of major revisions measured from claim
notification;
\item \code{claim_majRev_size}: the sizes of the major revision multipliers.
}

See Details for default.}

\item{paramfun}{parameters for the random sampling function, as a function of
other claim characteristics such as \code{claim_size}; see Details.}

\item{frequency_vector}{a vector of claim frequencies for all the periods
(not required if the \code{claims} argument is provided); see
\code{\link[SynthETIC]{claim_frequency}}.}

\item{claim_size_list}{list of claim sizes (not required if the \code{claims}
argument is provided); see \code{\link[SynthETIC]{claim_size}}.}

\item{...}{other arguments/parameters to be passed onto \code{paramfun}.}

\item{majRev_list}{nested list of major revision histories (with non-empty
revision frequencies).}

\item{settlement_list}{list of settlement delays (not required if the
\code{claims} argument is provided); see \code{\link[SynthETIC]{claim_closure}}.}

\item{payment_delay_list}{(compound) list of inter partial delays (not
required if the \code{claims} argument is provided); see
\code{\link[SynthETIC]{claim_payment_delay}}.}
}
\value{
A nested list structure such that the \emph{j}th component of the \emph{i}th
sub-list is a list of information on major revisions of the \emph{j}th claim of
occurrence period \emph{i}. The "unit list" (i.e. the smallest, innermost
sub-list) contains the following components:
\tabular{ll}{
\code{majRev_freq} \tab Number of major revisions of incurred loss
[\code{claim_majRev_freq()}]. \cr
\code{majRev_time} \tab Time of major revisions (from claim notification)
[\code{claim_majRev_time()}]. \cr
\code{majRev_factor} \tab Major revision multiplier of \strong{incurred loss}
[\code{claim_majRev_size()}]. \cr
\code{majRev_atP} \tab An indicator, \code{1} if the last major revision occurs at the
time of the last major payment (i.e. second last payment), \code{0} otherwise
[\code{claim_majRev_time()}].
}
}
\description{
A suite of functions that works together to simulate, in order, the (1)
frequency, (2) time, and (3) size of major revisions of incurred loss, for
each of the claims occurring in each of the periods.
}
\section{Details - \code{claim_majRev_freq} (Frequency)}{
 Let \emph{K} represent the number
of major revisions associated with a particular claim. The notification of a
claim is considered as a major revision, so all claims have at least 1 major
revision (\eqn{K \ge 1}).

The default \code{majRev_freq_function} specifies that no additional major revisions
will occur for claims of size smaller than or equal to \code{claim_size_benchmark}
(0.075 * \code{ref_claim} by default). For claims above this threshold,
\tabular{ll}{
\eqn{Pr(K = 2)} \tab \eqn{= 0.1 + 0.3min(1, (claim_size - 0.075 * ref_claim) / 0.925 * ref_claim)} \cr
\eqn{Pr(K = 3)} \tab \eqn{= 0.5min(1, max(0, claim_size - 0.25 * ref_claim)/ (0.75 * ref_claim))} \cr
\eqn{Pr(K = 1)} \tab \eqn{= 1 - Pr(K = 2) - Pr(K = 3)}
}
where \code{ref_claim} is a package-wise global variable that user should define
by \code{\link[SynthETIC]{set_parameters}} (if moving away from the default).

The idea is that	major revisions are more likely for larger claims, and do
not occur at all for the smallest claims. Note also that by default a claim
may experience \strong{up to a maximum of 2 major revisions} in addition to the
one at claim notification. This is taken as an assumption in the default
setting of \code{claim_majRev_size()}. If user decides to modify this assumption,
they will need to take care of the part on the major revision size as well.
}

\section{Details - \code{claim_majRev_time} (Time)}{
 Let \eqn{\tau_k} represent the
epoch of the \emph{k}th major revision (time measured from claim notification),
\eqn{k = 1, ..., K}. As the notification of a claim is considered a major
revision itself, we have \eqn{\tau_1 = 0} for all claims.

The last major revision for a claim may occur at the time of the second last
partial payment (which is usually the major settlement payment) with
probability
\deqn{0.2 min(1, max(0, (claim_size - ref_claim) / (14 * ref_claim)))}
where \code{ref_claim} is a package-wise global variable that user should define
by \code{\link[SynthETIC]{set_parameters}} (if moving away from the default).

Now, if there is a major revision at the time of the second last partial
payment, then \eqn{\tau_k, k = 2, ..., K - 1} are sampled from a triangular
distribution with parameters (see also \code{\link{ptri}})
\itemize{
\item \code{min = time_to_second_last_payment / 3}
\item \code{max = time_to_second_last_payment}
\item maximum density at \code{mode = time_to_second_last_payment / 3}.
}

Otherwise (i.e. no major revision at the time of the second last partial
payment), \eqn{\tau_k, k = 2, ..., K} are sampled from a triangular
distribution with parameters
\itemize{
\item \code{min = settlement_delay / 3}
\item \code{max = settlement_delay}
\item maximum density at \code{mode = settlement_delay / 3}.
}

Note that when there is a major revision at the time of the second last
partial payment, \code{majRev_atP} (one of the output list components) will be set
to be 1.
}

\section{Details - \code{claim_majRev_size} (Revision Multiplier)}{
 As mentioned in
the frequency section ("Details - \code{claim_majRev_freq}"), the default function
for the major revision multipliers assumes that there are only up to 2 major
revisions (in addition to the one at claim notification) for all claims.

By default,
\itemize{
\item the first major revision multiplier \eqn{g_1} is simply 1 (no meaning);
\item the second major revision multiplier \eqn{g_2} is sampled from a lognormal
distribution with parameters \code{meanlog} \eqn{ = 1.8} and \code{sdlog} \eqn{= 0.2};
\item the third major revision multiplier \eqn{g_3} is sampled from a lognormal
distribution with parameters \code{meanlog} \eqn{= 1 + 0.07(6 - g_2)} and \code{sdlog}
\eqn{= 0.1}. Note that the third major revision is likely to be smaller than
the second.
}

The revision multipliers are subject to further constraints to ensure that
the revised incurred estimate never falls below what has already been paid.
This is dicussed in \code{\link{claim_history}}.

\strong{The major revision multipliers apply to the incurred loss estimates}, that
is, a revision multiplier of 2.54 means that at the time of the major
revision the incurred loss increases by a factor of 2.54. We highlight this
as \strong{in the case of minor revisions, the multipliers will instead apply to
outstanding claim amounts}, see \code{\link{claim_minRev}}.
}

\examples{
set.seed(1)
test_claims <- SynthETIC::test_claims_object
major <- claim_majRev_freq(test_claims)
major[[1]][[1]] # the "unit list" for the first claim

# update the timing information
major <- claim_majRev_time(test_claims, major)
# observe how this has changed
major[[1]][[1]]

# update the revision multipliers
major <- claim_majRev_size(major)
# again observe how this has changed
major[[1]][[1]]
}
\seealso{
\code{\link[SynthETIC]{claims}}
}
