% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarymodel.R
\name{SummaryModel}
\alias{SummaryModel}
\title{Collects All Models Specified by "arimaSpec"}
\usage{
SummaryModel(x, maxorder = c(5, 1, 3), criterion = "bic", method = "CSS")
}
\arguments{
\item{x}{T by k data matrix: T data points in rows with each row being data at a given time point,
and k time series in columns.}

\item{maxorder}{Maximum order of \eqn{(p,d,q)} where \eqn{p} is the AR order, \eqn{d} the degree of differencing,
and \eqn{q} the MA order. Default value is (5,1,3).}

\item{criterion}{Information criterion used for model selection. Either AIC or BIC.
Default is "bic".}

\item{method}{Estimation method. See the arima command in R. Possible values are "CSS-ML", "ML", and "CSS".
Default is "CSS".}
}
\value{
A list containing:
\itemize{
   \item Order - Orders \eqn{(p, d, q)} of each series. A matrix of (ncol(x),3). The three columns are "p", "d", "q".
   \item Mean - A logical vector indicating whether each series needs a constant (or mean).
   \item M1 - A matrix with three columns (p, 0, q). The number of rows is the number of stationary time series. M1 is NULL if there is no stationary series.
   \item M2 - A matrix with three columns (p, 1, q). The number of rows is the number of first-differenced series. M2 is NULL if there is no first-differenced series.
   \item M3 - A matrix with three columns (p, 2, q). The number of rows is the number of 2nd-differenced series. M3 is NULL if there is no 2nd-differenced series.
   \item data - Time series.
}
}
\description{
Collects all models Specified by "arimaSpec".
}
\examples{
x <- matrix(rnorm(300, mean = 10, sd = 4), ncol = 3, nrow = 100)
summary <- SummaryModel(x)
}
