% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsBoost.R
\name{tsBoost}
\alias{tsBoost}
\title{Boosting with Simple Linear Regression}
\usage{
tsBoost(y, X, v = 0.01, m = 1000, rm.mean = TRUE)
}
\arguments{
\item{y}{T by 1 scalar dependent variable.}

\item{X}{T by k data matrix of predictors: T data points in rows with each row being data at a given time point,
and k time series in columns.}

\item{v}{Learning rate of boosting. Default value is 0.01.}

\item{m}{Maximum number of boosting iterations. Default is 1000.}

\item{rm.mean}{a logical command. Default is TRUE. If rm.mean=TRUE, both the dependent
and predictors are mean-adjusted. If rm.mean=FALSE, no mean adjustment is made.}
}
\value{
A list containing:
\itemize{
   \item beta - the estimates of coefficient vector.
   \item residuals - residuals after the boosting fit.
   \item m - the maximum number of boosting iterations (from input).
   \item v - learning rate (from input).
   \item selection - the indexes for selected predictors. That is, the indexes
   for large beta estimates.
   \item count: the number of selected predictors.
   \item yhat - the fitted value of y.
}
}
\description{
It uses simple linear regression as the weak learner to perform L2 Boosting for time series data.
}
\examples{
data(TaiwanAirBox032017)
output <- tsBoost(TaiwanAirBox032017[,1], TaiwanAirBox032017[,2])
}
