% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sSelectedSeries.R
\name{sSelectedSeries}
\alias{sSelectedSeries}
\title{Selected Seasonal Time Series}
\usage{
sSelectedSeries(M, order = c(0, 1, 1, 0, 1, 1))
}
\arguments{
\item{M}{Matrix that is an output from "sSummaryModel" command, that is, M1, M2, M3, M4, M5, or M6.}

\item{order}{order of ARIMA model \eqn{(p,d,q)*(P, D, Q)}. Default values is (0, 1, 1, 0, 1, 1).}
}
\value{
A list with the series names and count.
}
\description{
To be used after the command "sSummaryModel". The input "M" must be output from "sSummaryModel".
Selected seasonal time series of a given order \eqn{(p,d,q)*(P, D, Q)}.
}
\examples{
data(TaiwanAirBox032017)
outputSummaryModel <- sSummaryModel(TaiwanAirBox032017[,1:3])
sSelectedSeries(outputSummaryModel$M1)

}
