% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feedback_ml.R
\name{feedback.ml}
\alias{feedback.ml}
\title{Testing for Feedback Effects in a Simultaneous Equation Model}
\usage{
feedback.ml(data, out.decompose, eq.id, seed.in = 10, n.init = 50,
  range.init = c(-0.5, 0.5), info = T, maxit = 20000, perc.print = 0)
}
\arguments{
\item{data}{the data frame containing the data}

\item{out.decompose}{the decomposition object resulting from \code{causal.decompose()}}

\item{eq.id}{the equation to be tested for feedback effects}

\item{seed.in}{seed number for the perturbation parameters draws}

\item{n.init}{number of different initializations of the parameters}

\item{range.init}{range of the Uniform distribution for the perturbation on the initial values}

\item{info}{logical, prints the trace of the Nelder-Mead optimization routine}

\item{maxit}{maximum number of iterations for the Nelder-Mead optimization routine}

\item{perc.print}{print option: decimal number indicating how often (in percentage) information on the progress must be printed.}
}
\value{
A list with components \itemize{
\item \code{rho.est}: a data frame with the maximum likelihood estimate of \eqn{rho} and the
equations with which each element is involved in feedback-like mechanisms
\item \code{loglik}: the value of the log-likelihood
\item \code{theta.hessian}: the hessian matrix for the estimated parameters
\item \code{rho.jacobian}: the Jacobian matrix of \eqn{\rho} with respect to the entire set of parameters

}
}
\description{
Testing for Feedback Effects in a Simultaneous Equation Model
}
\examples{
\donttest{
data("macroIT")
eq.system = list(
              eq1 = C ~  CP  + I + CP_1,
              eq2 = I ~ K + CP_1,
              eq3 = WP ~ I + GDP + GDP_1,
              eq4 = GDP ~ C + I + GDP_1,
              eq5 = CP ~ WP + T,
              eq6 = K ~ I + K_1)

instruments = ~ T + CP_1 + GDP_1 + K_1

c.dec = causal.decompose(data = macroIT,
                         eq.system = eq.system,
                         resid.est = "noDfCor",
                         instruments = instruments,
                         p.adj = TRUE,
                         alpha = 0.05)

feedback.ml(data = macroIT,
              out.decompose = c.dec,
              eq.id = 2,
              seed.in = 10,
              n.init = 50,
              range.init = c(-1,1),
              info = TRUE,
              maxit = 1000,
              perc.print = 0)
              }

}
