% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Methods.R
\name{ci.LF}
\alias{ci.LF}
\title{Confidence Intervals for Bias-corrected LF Estimators}
\usage{
\method{ci}{LF}(
  object,
  probability = FALSE,
  alpha = 0.05,
  alternative = c("two.sided", "less", "greater"),
  ...
)
}
\arguments{
\item{object}{An object of class `LF`, a result of a call to `LF`}

\item{probability}{Whether returns CI with probability transformation or not (default=\code{FALSE})}

\item{alpha}{Level of significance to construct confidence interval (default=0.05)}

\item{alternative}{Indicates the alternative hypothesis to construct confidence interval and must be one of "two.sided" (default), "less", or "greater".}

\item{...}{arguments to pass down}
}
\value{
A matrix with columns giving lower and upper confidence limits for bias-corrected
estimators.
}
\description{
Computes confidence intervals for bias-corrected estimators; Each
row corresponds to a loading.
}
\examples{
\dontrun{
##-- Continuing the LF(.) example:
out = ci(Est)
out
}
}
\keyword{internal}
