% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_VolcanoPlot.R
\name{do_VolcanoPlot}
\alias{do_VolcanoPlot}
\title{Compute a Volcano plot out of DE genes.}
\usage{
do_VolcanoPlot(
  sample,
  de_genes,
  pval_cutoff = 0.05,
  FC_cutoff = 2,
  pt.size = 2,
  border.size = 1.5,
  border.color = "black",
  font.size = 14,
  font.type = "sans",
  plot.title = NULL,
  plot.subtitle = NULL,
  plot.caption = NULL,
  plot_lines = TRUE,
  line_color = "grey75",
  line_size = 0.5,
  add_gene_tags = TRUE,
  order_tags_by = "both",
  n_genes = 5,
  use_labels = FALSE,
  colors.use = "steelblue"
)
}
\arguments{
\item{sample}{\strong{\code{\link[SeuratObject]{Seurat}}} | A Seurat object, generated by \link[Seurat]{CreateSeuratObject}.}

\item{de_genes}{\strong{\code{\link[tibble]{tibble}}} | Output of \code{Seurat::FindMarkers()}.}

\item{pval_cutoff}{\strong{\code{\link[base]{numeric}}} | Cutoff for the p-value.}

\item{FC_cutoff}{\strong{\code{\link[base]{numeric}}} | Cutoff for the avg_log2FC.}

\item{pt.size}{\strong{\code{\link[base]{numeric}}} | Size of the dots.}

\item{border.size}{\strong{\code{\link[base]{numeric}}} | Width of the border of the cells.}

\item{border.color}{\strong{\code{\link[base]{character}}} | Color to use for the border of the cells.}

\item{font.size}{\strong{\code{\link[base]{numeric}}} | Overall font size of the plot. All plot elements will have a size relationship with this font size.}

\item{font.type}{\strong{\code{\link[base]{character}}} | Base font family for the plot. One of:
\itemize{
\item \emph{\code{mono}}: Mono spaced font.
\item \emph{\code{serif}}: Serif font family.
\item \emph{\code{sans}}: Default font family.
}}

\item{plot.title, plot.subtitle, plot.caption}{\strong{\code{\link[base]{character}}} | Title, subtitle or caption to use in the plot.}

\item{plot_lines}{\strong{\code{\link[base]{logical}}} | Whether to plot the division lines.}

\item{line_color}{\strong{\code{\link[base]{character}}} | Color for the lines.}

\item{line_size}{\strong{\code{\link[base]{numeric}}} | Size of the lines in the plot.}

\item{add_gene_tags}{\strong{\code{\link[base]{logical}}} | Whether to plot the top genes.}

\item{order_tags_by}{\strong{\code{\link[base]{character}}} | Either "both", "p_value" or "logfc".}

\item{n_genes}{\strong{\code{\link[base]{numeric}}} | Number of top genes in each side to plot.}

\item{use_labels}{\strong{\code{\link[base]{logical}}} | Whether to use labels instead of text for the tags.}

\item{colors.use}{\strong{\code{\link[base]{character}}} | Color to generate a tetradic color scale with.}
}
\value{
A volcano plot as a ggplot2 object.
}
\description{
Compute a Volcano plot out of DE genes.
}
\examples{
\donttest{
  # Check Suggests.
  value <- SCpubr:::check_suggests(function_name = "do_VolcanoPlot", passive = TRUE)

  if (isTRUE(value)){
    # Consult the full documentation in https://enblacar.github.io/SCpubr-book/

    # Define your Seurat object.
    sample <- readRDS(system.file("extdata/seurat_dataset_example.rds", package = "SCpubr"))

    # Retrieve DE genes.
    de_genes <- readRDS(system.file("extdata/de_genes_example.rds", package = "SCpubr"))

    # Generate a volcano plot.
    p <- SCpubr::do_VolcanoPlot(sample = sample,
                                de_genes = de_genes)
    p

  } else if (isFALSE(value)){
    message("This function can not be used without its suggested packages.")
    message("Check out which ones are needed using `SCpubr::state_dependencies()`.")
  }
}
}
