% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/db_manipulating_functions.R
\name{interlace_sql}
\alias{interlace_sql}
\title{Combine any number of SQL queries, where each has their own time axis of
validity (valid_from and valid_until)}
\usage{
interlace_sql(tables, by = NULL, colnames = NULL)
}
\arguments{
\item{tables}{A list(!) of tables you want to combine is supplied here as
lazy_queries.}

\item{by}{The (group) variable to merge by}

\item{colnames}{If the time axes of validity is not called "valid_to" and
"valid_until" inside each lazy_query, you can specify their
names by supplying the arguments as a list
(e.g. c(t1.from = "\<colname\>", t2.until = "\<colname\>").
colnames must be named in same order as as given in tables
(i.e. t1, t2, t3, ...).}
}
\value{
\if{html}{\out{<div class="sourceCode">}}\preformatted{     The combination of input queries with a single, interlaced
             valid_from / valid_until time axis
}\if{html}{\out{</div>}}
}
\description{
The function "interlaces" the queries and combines their validity time axes
onto a single time axis
}
\examples{
conn <- get_connection(drv = RSQLite::SQLite())


if (schema_exists(conn, "test")) {
  t1 <- data.frame(key = c("A", "A", "B"),
                  obs_1   = c(1, 2, 2),
                  valid_from  = as.Date(c("2021-01-01", "2021-02-01", "2021-01-01")),
                  valid_until = as.Date(c("2021-02-01", "2021-03-01", NA)))
  t1 <- dplyr::copy_to(conn, t1, id("test.SCDB_tmp1", conn), overwrite = TRUE, temporary = FALSE)

  t2 <- data.frame(key = c("A", "B"),
                  obs_2 = c("a", "b"),
                  valid_from  = as.Date(c("2021-01-01", "2021-01-01")),
                  valid_until = as.Date(c("2021-04-01", NA)))
  t2 <- dplyr::copy_to(conn, t2, id("test.SCDB_tmp2", conn), overwrite = TRUE, temporary = FALSE)

  interlace_sql(list(t1, t2), by = "key")
}

close_connection(conn)
}
