% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcgDijkstra.r
\name{vcgGeodesicPath}
\alias{vcgGeodesicPath}
\title{Compute geodesic path and path length between vertices on a mesh}
\usage{
vcgGeodesicPath(x, source, targets, maxdist = 1e+06)
}
\arguments{
\item{x}{triangular mesh of class \code{mesh3d} from the \code{rgl} package.}

\item{source}{scalar positive integer, the source vertex index.}

\item{targets}{positive integer vector, the target vertex indices.}

\item{maxdist}{numeric, the maximal distance to travel along the mesh edges during geodesic distance computation.}
}
\value{
named list with two entries as follows. \code{'paths'}: list of integer vectors, representing the paths. \code{'geodist'}: double vector, the geodesic distances from the source vertex to all vertices in the graph.
}
\description{
Compute geodesic path and path length between vertices on a mesh
}
\note{
Currently no reachability checks are performed, so you have to be sure that the mesh is connected, or at least that the source and target vertices are reachable from one another.
}
\examples{
data(humface)
p = vcgGeodesicPath(humface,50,c(500,5000))
p$paths[[1]];   # The path 50..500
p$geodist[500]; # Its path length.
}
