% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcgKmeans.r
\name{vcgKmeans}
\alias{vcgKmeans}
\title{fast Kmean clustering for 1D, 2D and 3D data}
\usage{
vcgKmeans(x, k = 10, iter.max = 10, getClosest = FALSE,
  threads = 0)
}
\arguments{
\item{x}{matrix containing coordinates or mesh3d}

\item{k}{number of clusters}

\item{iter.max}{maximum number of iterations}

\item{getClosest}{logical: if TRUE the indices of the points closest to the k-centers are sought.}

\item{threads}{integer: number of threads to use}
}
\value{
returns a list containing
\item{centers}{cluster center}
\item{class}{vector with cluster association for each coordinate}
If \code{getClosest=TRUE}
 \item{selected}{vector with indices of points closest to the centers}
}
\description{
fast Kmean clustering for 1D, 2D and 3D data
}
\examples{
require(Rvcg);require(rgl)
data(humface)
set.seed(42)
clust <- vcgKmeans(humface,k=1000,threads=1)
}
\seealso{
\code{\link{vcgSample}}
}
