% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RsqMed.R
\name{Rsq.measure}
\alias{Rsq.measure}
\title{Function to calculate the Rsq function as a total mediation effect size measure (Gaussian outcome only). If method='iSIS', a two-step procedure is performed, where the first step filters the non-mediators based on part of the data and the second step calculates the point estimates for Rsq using random-effect models on the remaining data. If method='ALL', Rsq is calculated based on all subjects and variables.}
\usage{
Rsq.measure(p = 1/2, outcome, med, covar, indp, method = c("iSIS",
  "ALL"), iter.max = 10, nsis = NULL, init.cutoff = 0.1,
  screening = FALSE)
}
\arguments{
\item{p}{Proportion of the training dataset for selecting mediators regarding the whole dataset, default is set as 1/2. If method='ALL', keep p at default.}

\item{outcome}{Vector of outcome type of interest; Only Gaussian distributed outcome is accepted.}

\item{med}{Matrix of putative mediators}

\item{covar}{Covariate matrix}

\item{indp}{Vector of the independent variable of interest, e.g. environmental variable}

\item{method}{Method used to screen out non-mediators. When no variable selection is required, method='ALL'; otherwise, iterative sure independence screening (SIS) is used for variable selection, i.e., method='iSIS'. Note that when method='ALL', no screening is performed, i.e., the Rsq measure is calculated on all data and all variables included.}

\item{iter.max}{Maximum number of iteration used in iSIS, default=10 (please refer the SIS package for detail explanation)}

\item{nsis}{Number of variables recruited by iterative SIS}

\item{init.cutoff}{The percentage of mediators remaining after the screening step.}

\item{screening}{T if filtering mediators based on the strength of independent variable and mediators as a preprocessing step; F if all putative mediators are included, default=F.}
}
\value{
Output vector consist of Rsq mediated(Rsq.mediated), shared over simple effects (SOS), number of selected mediators (pab), and the Rsq that used to calculate the Rsq measure: variance of outcome explained by mediator (Rsq.YM), variance of outcome explained by the independent variable (Rsq.YX), and variance of outcome explained by mediator and independent variable (Rsq.YMX), n is the sample size based on which the random effect models are fitted.

Name of selected mediators (select)
}
\description{
Function to calculate the Rsq function as a total mediation effect size measure (Gaussian outcome only). If method='iSIS', a two-step procedure is performed, where the first step filters the non-mediators based on part of the data and the second step calculates the point estimates for Rsq using random-effect models on the remaining data. If method='ALL', Rsq is calculated based on all subjects and variables.
}
\examples{
{
#\donttest{
data(example)
attach(example)
Rsq.measure(p=1/2, outcome=Y, med=M,covar=Cov,indp=X,method='iSIS', iter.max=1)
#}
}
}
