% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary-heterogeneity.R
\name{summary_heterogeneity}
\alias{summary_heterogeneity}
\title{Summarizes heterogeneity of a RoBMA model}
\usage{
summary_heterogeneity(
  object,
  type = "ensemble",
  conditional = FALSE,
  output_scale = NULL,
  probs = c(0.025, 0.975),
  short_name = FALSE,
  remove_spike_0 = FALSE
)
}
\arguments{
\item{object}{a fitted RoBMA object}

\item{type}{whether to show the overall RoBMA results (\code{"ensemble"})
or a detailed summary of the individual models (\code{"individual"}).
Can be abbreviated to first letters.}

\item{conditional}{show the conditional estimates (assuming that the
alternative is true). Defaults to \code{FALSE}. Only available for
\code{type == "ensemble"}.}

\item{output_scale}{transform the  meta-analytic estimates to a different
scale. Defaults to \code{NULL} which returns the same scale as the model was estimated on.}

\item{probs}{quantiles of the posterior samples to be displayed.
Defaults to \code{c(.025, .975)}}

\item{short_name}{whether priors names should be shortened to the first
(couple) of letters. Defaults to \code{FALSE}.}

\item{remove_spike_0}{whether spike prior distributions with location at zero should
be omitted from the summary. Defaults to \code{FALSE}.}
}
\value{
\code{summary.RoBMA} returns a list of tables of class 'BayesTools_table'.
}
\description{
Computes the prediction interval, the absolute
heterogeneity  (tau, tau^2), and relative measures of heterogeneity
(I^2, H^2) for a fitted RoBMA object.
}
