% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priors.R
\name{check_setup}
\alias{check_setup}
\title{Prints summary of \code{"RoBMA"} ensemble implied by the specified priors}
\usage{
check_setup(
  priors_mu = prior(distribution = "normal", parameters = list(mean = 0, sd = 1)),
  priors_tau = prior(distribution = "invgamma", parameters = list(shape = 1, scale =
    0.15)),
  priors_omega = list(prior(distribution = "two.sided", parameters = list(alpha = c(1,
    1), steps = c(0.05)), prior_odds = 1/2), prior(distribution = "two.sided", parameters
    = list(alpha = c(1, 1, 1), steps = c(0.05, 0.1)), prior_odds = 1/2)),
  priors_mu_null = prior(distribution = "point", parameters = list(location = 0)),
  priors_tau_null = prior(distribution = "point", parameters = list(location = 0)),
  priors_omega_null = prior(distribution = "point", parameters = list(location = 1)),
  models = FALSE,
  silent = FALSE
)
}
\arguments{
\item{priors_mu}{list of prior distributions for the \code{mu} parameter that
will be treated as belonging to the alternative hypothesis. Defaults to \code{
prior(distribution = "normal",   parameters = list(mean = 0, sd = 1))}.}

\item{priors_tau}{list of prior distributions for the \code{tau} parameter that
will be treated as belonging to the alternative hypothesis. Defaults to \code{
prior(distribution = "invgamma", parameters = list(shape = 1, scale = .15))}.}

\item{priors_omega}{list of prior weight functions for the \code{omega}
parameter that will be treated as belonging to the alternative hypothesis.
Defaults to \code{list(
prior(distribution = "two.sided", parameters = list(alpha = c(1, 1),     steps = c(.05)),      prior_odds = 1/2),
prior(distribution = "two.sided", parameters = list(alpha = c(1, 1, 1),  steps = c(.05, .10)), prior_odds = 1/2)
)}.}

\item{priors_mu_null}{list of prior distributions for the \code{mu} parameter that
will be treated as belonging to the null hypothesis. Defaults to point distribution
with location at 0 (
\code{prior(distribution = "point", parameters = list(location = 0))}).}

\item{priors_tau_null}{list of prior distributions for the \code{tau} parameter that
will be treated as belonging to the null hypothesis. Defaults to point distribution
with location at 0 (
\code{prior(distribution = "point", parameters = list(location = 0))}).}

\item{priors_omega_null}{list of prior weight functions for the \code{omega} parameter
that will be treated as belonging to the null hypothesis. Defaults to point
distribution with location at 1 (
\code{prior(distribution = "point", parameters = list(location = 0))}).}

\item{models}{should the models' details be printed.}

\item{silent}{do not print the results.}
}
\description{
\code{check_setup} prints summary of \code{"RoBMA"} ensemble
implied by the specified prior distributions. It is useful for checking
the ensemble configuration prior to fitting all of the models.
}
\seealso{
\code{\link[=RoBMA]{RoBMA()}}, \code{\link[=prior]{prior()}}
}
